/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

public class StringUtil {
    public static char[] hex2CharArray(String hex) {
        if (hex == null) {
            return null;
        }
        int length = hex.length();
        if ((1 & length) != 0) {
            throw new IllegalArgumentException("'" + hex + "' has odd length!");
        }
        char[] result = new char[length /= 2];
        int indexDest = 0;
        int indexSrc = 0;
        while (indexDest < length) {
            int digit = Character.digit(hex.charAt(indexSrc), 16);
            if (digit < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            result[indexDest] = (char)(digit << 4);
            if ((digit = Character.digit(hex.charAt(++indexSrc), 16)) < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            int n = indexDest++;
            result[n] = (char)(result[n] | (char)digit);
            ++indexSrc;
        }
        return result;
    }

    public static String byteArray2HexString(byte[] byteArray, int max) {
        if (byteArray != null && byteArray.length != 0) {
            if (max == 0 || max > byteArray.length) {
                max = byteArray.length;
            }
            StringBuilder builder = new StringBuilder(max * 3);
            for (int i = 0; i < max; ++i) {
                builder.append(String.format("%02X", 0xFF & byteArray[i]));
                if (i >= max - 1) continue;
                builder.append(' ');
            }
            return builder.toString();
        }
        return "--";
    }

    public static String trunc(String text, int maxLength) {
        if (text != null && maxLength > 0 && maxLength < text.length()) {
            return text.substring(0, maxLength - 1);
        }
        return text;
    }
}

