/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.MapBasedEndpointContext;

public class TcpEndpointContext
extends MapBasedEndpointContext {
    public static final String KEY_CONNECTION_ID = "CONNECTION_ID";

    public TcpEndpointContext(InetSocketAddress peerAddress, String connectionId) {
        this(peerAddress, null, KEY_CONNECTION_ID, connectionId);
    }

    protected TcpEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String ... attributes) {
        super(peerAddress, peerIdentity, attributes);
        if (null == this.getConnectionId()) {
            throw new IllegalArgumentException("Missing attribute ");
        }
    }

    public String getConnectionId() {
        return this.get(KEY_CONNECTION_ID);
    }

    @Override
    public String toString() {
        return String.format("TCP(%s:%d,ID:%s)", this.getPeerAddress().getHostString(), this.getPeerAddress().getPort(), this.getConnectionId());
    }
}

