/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.MessageCallback;

public final class RawData {
    public final byte[] bytes;
    private boolean multicast;
    private EndpointContext peerEndpointContext;
    private MessageCallback callback;

    private RawData(byte[] data, EndpointContext peerEndpointContext, MessageCallback callback, boolean multicast) {
        if (data == null) {
            throw new NullPointerException("Data must not be null");
        }
        if (peerEndpointContext == null) {
            throw new NullPointerException("Peer's EndpointContext must not be null");
        }
        this.bytes = data;
        this.peerEndpointContext = peerEndpointContext;
        this.callback = callback;
        this.multicast = multicast;
    }

    public static RawData inbound(byte[] data, EndpointContext peerEndpointContext, boolean isMulticast) {
        return new RawData(data, peerEndpointContext, null, isMulticast);
    }

    public static RawData outbound(byte[] data, EndpointContext peerEndpointContext, MessageCallback callback, boolean useMulticast) {
        return new RawData(data, peerEndpointContext, callback, useMulticast);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public int getSize() {
        return this.bytes.length;
    }

    public InetAddress getAddress() {
        return this.peerEndpointContext.getPeerAddress().getAddress();
    }

    public int getPort() {
        return this.peerEndpointContext.getPeerAddress().getPort();
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.peerEndpointContext.getPeerAddress();
    }

    public Principal getSenderIdentity() {
        return this.peerEndpointContext.getPeerIdentity();
    }

    public EndpointContext getEndpointContext() {
        return this.peerEndpointContext;
    }

    public void onContextEstablished(EndpointContext context) {
        if (null != this.callback) {
            this.callback.onContextEstablished(context);
        }
    }

    public void onSent() {
        if (null != this.callback) {
            this.callback.onSent();
        }
    }

    public void onError(Throwable error) {
        if (null != this.callback) {
            if (null == error) {
                error = new UnknownError();
            }
            this.callback.onError(error);
        }
    }
}

