/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointContextUtil;

public class KeySetEndpointContextMatcher
implements EndpointContextMatcher {
    private final String name;
    private final Set<String> keys;

    public KeySetEndpointContextMatcher(String name, String[] keys) {
        this.name = name;
        this.keys = KeySetEndpointContextMatcher.createKeySet(keys);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        return this.internalMatch(requestContext, responseContext);
    }

    @Override
    public boolean isToBeSent(EndpointContext messageContext, EndpointContext connectionContext) {
        if (null == connectionContext) {
            return !messageContext.inhibitNewConnection();
        }
        return this.internalMatch(messageContext, connectionContext);
    }

    private final boolean internalMatch(EndpointContext requestedContext, EndpointContext availableContext) {
        if (!requestedContext.inhibitNewConnection()) {
            return true;
        }
        return EndpointContextUtil.match(this.getName(), this.keys, requestedContext, availableContext);
    }

    public static Set<String> createKeySet(String ... keys) {
        return Collections.unmodifiableSet(new CopyOnWriteArraySet<String>(Arrays.asList(keys)));
    }
}

