/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

public class StringUtil {
    public static char[] hex2CharArray(String hex) {
        if (null == hex) {
            return null;
        }
        int length = hex.length();
        if ((1 & length) != 0) {
            throw new IllegalArgumentException("'" + hex + "' has odd length!");
        }
        char[] result = new char[length /= 2];
        int indexDest = 0;
        int indexSrc = 0;
        while (indexDest < length) {
            int digit = Character.digit(hex.charAt(indexSrc), 16);
            if (0 > digit) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            result[indexDest] = (char)(digit << 4);
            if (0 > (digit = Character.digit(hex.charAt(++indexSrc), 16))) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            int n = indexDest++;
            result[n] = (char)(result[n] | (char)digit);
            ++indexSrc;
        }
        return result;
    }
}

