/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp;

import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;

class CloseOnErrorHandler
extends ChannelHandlerAdapter {
    private static final Logger LOGGER = Logger.getLogger(CloseOnErrorHandler.class.getName());

    CloseOnErrorHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            Throwable rootCause = cause;
            while (null != rootCause.getCause()) {
                rootCause = rootCause.getCause();
            }
            if (!LOGGER.isLoggable(Level.FINER) && (rootCause instanceof SSLException || rootCause instanceof GeneralSecurityException)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.SEVERE, "Security Exception in channel handler chain for endpoint " + ctx.channel().remoteAddress() + ". Closing connection.", rootCause);
                } else {
                    LOGGER.log(Level.SEVERE, "{0} in channel handler chain for endpoint {1}. Closing connection.", new Object[]{rootCause, ctx.channel().remoteAddress()});
                }
            } else {
                LOGGER.log(Level.SEVERE, "Exception in channel handler chain for endpoint " + ctx.channel().remoteAddress() + ". Closing connection.", cause);
            }
        }
        finally {
            ctx.close();
        }
    }
}

