/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.californium.elements.util.StringUtil;

public class SslContextUtil {
    public static final String CLASSPATH_PROTOCOL = "classpath://";
    public static final String PARAMETER_SEPARATOR = "#";

    public static Certificate[] loadTrustedCertificates(String trust) throws IOException, GeneralSecurityException {
        if (null == trust) {
            throw new NullPointerException("trust must be provided!");
        }
        String[] parameters = trust.split(PARAMETER_SEPARATOR, 3);
        if (3 != parameters.length) {
            throw new IllegalArgumentException("trust must comply the pattern <keystore#hexstorepwd#aliaspattern>");
        }
        return SslContextUtil.loadTrustedCertificates(parameters[0], parameters[2], StringUtil.hex2CharArray(parameters[1]));
    }

    public static Credentials loadCredentials(String credentials) throws IOException, GeneralSecurityException {
        if (null == credentials) {
            throw new NullPointerException("credentials must be provided!");
        }
        String[] parameters = credentials.split(PARAMETER_SEPARATOR, 4);
        if (4 != parameters.length) {
            throw new IllegalArgumentException("credentials must comply the pattern <keystore#hexstorepwd#hexkeypwd#alias>");
        }
        return SslContextUtil.loadCredentials(parameters[0], parameters[3], StringUtil.hex2CharArray(parameters[1]), StringUtil.hex2CharArray(parameters[2]));
    }

    public static TrustManager[] loadTrustManager(String keyStoreUri, String aliasPattern, char[] storePassword) throws IOException, GeneralSecurityException {
        Certificate[] trustedCertificates = SslContextUtil.loadTrustedCertificates(keyStoreUri, aliasPattern, storePassword);
        return SslContextUtil.createTrustManager("trusts", trustedCertificates);
    }

    public static KeyManager[] loadKeyManager(String keyStoreUri, String alias, char[] storePassword, char[] keyPassword) throws IOException, GeneralSecurityException {
        if (null == keyPassword) {
            throw new NullPointerException("keyPassword must be provided!");
        }
        KeyStore ks = SslContextUtil.loadKeyStore(keyStoreUri, alias, storePassword, keyPassword);
        return SslContextUtil.createKeyManager(ks, keyPassword);
    }

    public static Certificate[] loadTrustedCertificates(String keyStoreUri, String aliasPattern, char[] storePassword) throws IOException, GeneralSecurityException {
        KeyStore ks = SslContextUtil.loadKeyStore(keyStoreUri, storePassword);
        Pattern pattern = null;
        if (null != aliasPattern && !aliasPattern.isEmpty()) {
            pattern = Pattern.compile(aliasPattern);
        }
        ArrayList<Certificate> trustedCertificates = new ArrayList<Certificate>();
        Enumeration<String> e = ks.aliases();
        while (e.hasMoreElements()) {
            Certificate certificate;
            Matcher matcher;
            String alias = e.nextElement();
            if (null != pattern && !(matcher = pattern.matcher(alias)).matches() || null == (certificate = ks.getCertificate(alias))) continue;
            trustedCertificates.add(certificate);
        }
        if (trustedCertificates.isEmpty()) {
            throw new IllegalArgumentException("no trusted x509 certificates found in '" + keyStoreUri + "' for '" + aliasPattern + "'!");
        }
        return trustedCertificates.toArray(new Certificate[trustedCertificates.size()]);
    }

    public static Credentials loadCredentials(String keyStoreUri, String alias, char[] storePassword, char[] keyPassword) throws IOException, GeneralSecurityException {
        KeyStore.Entry entry;
        if (null == alias) {
            throw new NullPointerException("alias must be provided!");
        }
        if (alias.isEmpty()) {
            throw new IllegalArgumentException("alias must not be empty!");
        }
        if (null == keyPassword) {
            throw new NullPointerException("keyPassword must be provided!");
        }
        KeyStore ks = SslContextUtil.loadKeyStore(keyStoreUri, storePassword);
        if (ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) && (entry = ks.getEntry(alias, new KeyStore.PasswordProtection(keyPassword))) instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)entry;
            Certificate[] chain = pkEntry.getCertificateChain();
            X509Certificate[] x509Chain = SslContextUtil.asX509Certificates(chain);
            return new Credentials(pkEntry.getPrivateKey(), x509Chain);
        }
        throw new IllegalArgumentException("no credentials found for '" + alias + "' in '" + keyStoreUri + "'!");
    }

    public static X509Certificate[] loadCertificateChain(String keyStoreUri, String alias, char[] storePassword) throws IOException, GeneralSecurityException {
        if (null == alias) {
            throw new NullPointerException("alias must be provided!");
        }
        if (alias.isEmpty()) {
            throw new IllegalArgumentException("alias must not be empty!");
        }
        KeyStore ks = SslContextUtil.loadKeyStore(keyStoreUri, storePassword);
        Certificate[] chain = ks.getCertificateChain(alias);
        return SslContextUtil.asX509Certificates(chain);
    }

    private static KeyStore loadKeyStore(String keyStoreUri, String alias, char[] storePassword, char[] keyPassword) throws IOException, GeneralSecurityException {
        KeyStore ks = SslContextUtil.loadKeyStore(keyStoreUri, storePassword);
        if (null == alias || alias.isEmpty()) {
            return ks;
        }
        if (null == keyPassword) {
            Certificate certificate = ks.getCertificate(alias);
            if (null != certificate) {
                KeyStore ksAlias = KeyStore.getInstance("JKS");
                ksAlias.load(null);
                ksAlias.setCertificateEntry(alias, certificate);
                return ksAlias;
            }
            throw new GeneralSecurityException("key stores '" + keyStoreUri + "' doesn't contain certificates for '" + alias + "'");
        }
        KeyStore.Entry entry = ks.getEntry(alias, new KeyStore.PasswordProtection(keyPassword));
        if (null != entry) {
            KeyStore ksAlias = KeyStore.getInstance("JKS");
            ksAlias.load(null);
            ksAlias.setEntry(alias, entry, new KeyStore.PasswordProtection(keyPassword));
            return ksAlias;
        }
        throw new GeneralSecurityException("key stores '" + keyStoreUri + "' doesn't contain credentials for '" + alias + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String keyStoreUri, char[] storePassword) throws GeneralSecurityException, IOException {
        InputStream inStream;
        if (null == keyStoreUri) {
            throw new NullPointerException("keyStoreUri must be provided!");
        }
        if (null == storePassword) {
            throw new NullPointerException("storePassword must be provided!");
        }
        if (keyStoreUri.startsWith(CLASSPATH_PROTOCOL)) {
            String resource = keyStoreUri.substring(CLASSPATH_PROTOCOL.length());
            inStream = SslContextUtil.class.getClassLoader().getResourceAsStream(resource);
            if (null == inStream) {
                throw new IOException("'" + keyStoreUri + "' not found!");
            }
        } else {
            URL url = new URL(keyStoreUri);
            inStream = url.openStream();
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(inStream, storePassword);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        finally {
            inStream.close();
        }
    }

    private static X509Certificate[] asX509Certificates(Certificate[] certificates) {
        if (null == certificates || 0 == certificates.length) {
            throw new IllegalArgumentException("certificates missing!");
        }
        X509Certificate[] x509Certificates = new X509Certificate[certificates.length];
        for (int index = 0; certificates.length > index; ++index) {
            if (null == certificates[index]) {
                throw new IllegalArgumentException("[" + index + "] is null!");
            }
            try {
                x509Certificates[index] = (X509Certificate)certificates[index];
                continue;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("[" + index + "] is not a x509 certificate! Instead it's a " + certificates[index].getClass().getName());
            }
        }
        return x509Certificates;
    }

    public static SSLContext createSSLContext(String alias, PrivateKey privateKey, X509Certificate[] chain, Certificate[] trusts) throws GeneralSecurityException {
        if (null == alias) {
            alias = "californium";
        }
        KeyManager[] keyManager = SslContextUtil.createKeyManager(alias, privateKey, chain);
        TrustManager[] trustManager = SslContextUtil.createTrustManager(alias, trusts);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManager, trustManager, null);
        return sslContext;
    }

    public static KeyManager[] createKeyManager(String alias, PrivateKey privateKey, X509Certificate[] chain) throws GeneralSecurityException {
        if (null == privateKey) {
            throw new NullPointerException("private key must be provided!");
        }
        if (null == chain) {
            throw new NullPointerException("certificate chain must be provided!");
        }
        if (0 == chain.length) {
            throw new IllegalArgumentException("certificate chain must not be empty!");
        }
        if (null == alias) {
            alias = "californium";
        }
        try {
            char[] key = "intern".toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null);
            ks.setKeyEntry(alias, privateKey, key, chain);
            return SslContextUtil.createKeyManager(ks, key);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e.getMessage());
        }
    }

    public static TrustManager[] createTrustManager(String alias, Certificate[] trusts) throws GeneralSecurityException {
        if (null == trusts) {
            throw new NullPointerException("trusted certificates must be provided!");
        }
        if (0 == trusts.length) {
            throw new IllegalArgumentException("trusted certificates must not be empty!");
        }
        if (null == alias) {
            alias = "californium";
        }
        try {
            int index = 1;
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(null);
            for (Certificate certificate : trusts) {
                ks.setCertificateEntry(alias + index, certificate);
                ++index;
            }
            return SslContextUtil.createTrustManager(ks);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e.getMessage());
        }
    }

    private static KeyManager[] createKeyManager(KeyStore store, char[] keyPassword) throws GeneralSecurityException {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(store, keyPassword);
        return kmf.getKeyManagers();
    }

    private static TrustManager[] createTrustManager(KeyStore store) throws GeneralSecurityException {
        String algorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
        tmf.init(store);
        return tmf.getTrustManagers();
    }

    public static class Credentials {
        private final PrivateKey privateKey;
        private final X509Certificate[] chain;

        private Credentials(PrivateKey privateKey, X509Certificate[] chain) {
            this.privateKey = privateKey;
            this.chain = chain;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public X509Certificate[] getCertificateChain() {
            return this.chain;
        }
    }
}

