/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.californium.elements.CorrelationContext;
import org.eclipse.californium.elements.CorrelationContextMatcher;
import org.eclipse.californium.elements.CorrelationContextUtil;

public class KeySetCorrelationContextMatcher
implements CorrelationContextMatcher {
    private final String name;
    private final Set<String> keys;

    public KeySetCorrelationContextMatcher(String name, String[] keys) {
        this.name = name;
        this.keys = KeySetCorrelationContextMatcher.createKeySet(keys);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isResponseRelatedToRequest(CorrelationContext requestContext, CorrelationContext responseContext) {
        return this.internalMatch(requestContext, responseContext);
    }

    @Override
    public boolean isToBeSent(CorrelationContext messageContext, CorrelationContext connectorContext) {
        return this.internalMatch(messageContext, connectorContext);
    }

    private final boolean internalMatch(CorrelationContext requestedContext, CorrelationContext availableContext) {
        if (null == requestedContext) {
            return true;
        }
        if (null == availableContext) {
            return false;
        }
        return CorrelationContextUtil.match(this.getName(), this.keys, requestedContext, availableContext);
    }

    public static Set<String> createKeySet(String ... keys) {
        return Collections.unmodifiableSet(new CopyOnWriteArraySet<String>(Arrays.asList(keys)));
    }
}

