/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import org.eclipse.californium.elements.MapBasedCorrelationContext;

public class DtlsCorrelationContext
extends MapBasedCorrelationContext {
    public static final String KEY_SESSION_ID = "DTLS_SESSION_ID";
    public static final String KEY_EPOCH = "DTLS_EPOCH";
    public static final String KEY_CIPHER = "DTLS_CIPHER";

    public DtlsCorrelationContext(String sessionId, String epoch, String cipher) {
        if (sessionId == null) {
            throw new NullPointerException("Session ID must not be null");
        }
        if (epoch == null) {
            throw new NullPointerException("Epoch must not be null");
        }
        if (cipher == null) {
            throw new NullPointerException("Cipher must not be null");
        }
        this.put(KEY_SESSION_ID, sessionId);
        this.put(KEY_EPOCH, epoch);
        this.put(KEY_CIPHER, cipher);
    }

    public String getSessionId() {
        return this.get(KEY_SESSION_ID);
    }

    public String getEpoch() {
        return this.get(KEY_EPOCH);
    }

    public String getCipher() {
        return this.get(KEY_CIPHER);
    }
}

