/*
 * Decompiled with CFR 0.152.
 */
package eu.javaspecialists.tjsn.concurrency.stripedexecutor;

import eu.javaspecialists.tjsn.concurrency.stripedexecutor.StripedObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class StripedExecutorService
extends AbstractExecutorService {
    private final ExecutorService executor;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition terminating = this.lock.newCondition();
    private final Map<Object, SerialExecutor> executors = new HashMap<Object, SerialExecutor>();
    private static final ThreadLocal<Object> stripes = new ThreadLocal();
    private State state = State.RUNNING;
    private static boolean DEBUG = false;

    private StripedExecutorService(ExecutorService executor) {
        this.executor = executor;
    }

    public StripedExecutorService() {
        this(Executors.newCachedThreadPool());
    }

    public StripedExecutorService(int numberOfThreads) {
        this(Executors.newFixedThreadPool(numberOfThreads));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        this.saveStripedObject(runnable);
        return super.newTaskFor(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        this.saveStripedObject(callable);
        return super.newTaskFor(callable);
    }

    private void saveStripedObject(Object task) {
        if (StripedExecutorService.isStripedObject(task)) {
            stripes.set(((StripedObject)task).getStripe());
        }
    }

    private static boolean isStripedObject(Object o) {
        return o instanceof StripedObject;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.lock.lock();
        try {
            this.checkPoolIsRunning();
            if (StripedExecutorService.isStripedObject(task)) {
                Future<T> future = super.submit(task, result);
                return future;
            }
            Future<T> future = this.executor.submit(task, result);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.lock.lock();
        try {
            this.checkPoolIsRunning();
            if (StripedExecutorService.isStripedObject(task)) {
                Future<T> future = super.submit(task);
                return future;
            }
            Future<T> future = this.executor.submit(task);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkPoolIsRunning() {
        assert (this.lock.isHeldByCurrentThread());
        if (this.state != State.RUNNING) {
            throw new RejectedExecutionException("executor not running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        this.lock.lock();
        try {
            this.checkPoolIsRunning();
            Object stripe = this.getStripe(command);
            if (stripe != null) {
                SerialExecutor ser_exec = this.executors.get(stripe);
                if (ser_exec == null) {
                    ser_exec = new SerialExecutor(stripe);
                    this.executors.put(stripe, ser_exec);
                }
                ser_exec.execute(command);
            } else {
                this.executor.execute(command);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private Object getStripe(Runnable command) {
        Object stripe = command instanceof StripedObject ? ((StripedObject)((Object)command)).getStripe() : stripes.get();
        stripes.remove();
        return stripe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            this.state = State.SHUTDOWN;
            if (this.executors.isEmpty()) {
                this.executor.shutdown();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.lock.lock();
        try {
            this.shutdown();
            ArrayList<Runnable> result = new ArrayList<Runnable>();
            for (SerialExecutor ser_ex : this.executors.values()) {
                ser_ex.tasks.drainTo(result);
            }
            result.addAll(this.executor.shutdownNow());
            ArrayList<Runnable> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.state == State.SHUTDOWN;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        this.lock.lock();
        try {
            if (this.state == State.RUNNING) {
                boolean bl = false;
                return bl;
            }
            for (SerialExecutor executor : this.executors.values()) {
                if (executor.isEmpty()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = this.executor.isTerminated();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            long remainingTime;
            long waitUntil = System.nanoTime() + unit.toNanos(timeout);
            while ((remainingTime = waitUntil - System.nanoTime()) > 0L && !this.executors.isEmpty()) {
                this.terminating.awaitNanos(remainingTime);
            }
            if (remainingTime <= 0L) {
                boolean bl = false;
                return bl;
            }
            if (this.executors.isEmpty()) {
                boolean bl = this.executor.awaitTermination(remainingTime, TimeUnit.NANOSECONDS);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeEmptySerialExecutor(Object stripe, SerialExecutor ser_ex) {
        assert (ser_ex == this.executors.get(stripe));
        assert (this.lock.isHeldByCurrentThread());
        assert (ser_ex.isEmpty());
        this.executors.remove(stripe);
        this.terminating.signalAll();
        if (this.state == State.SHUTDOWN && this.executors.isEmpty()) {
            this.executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            String string = "StripedExecutorService: state=" + (Object)((Object)this.state) + ", " + "executor=" + this.executor + ", " + "serialExecutors=" + this.executors;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private class SerialExecutor
    implements Executor {
        private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
        private Runnable active;
        private final Object stripe;

        private SerialExecutor(Object stripe) {
            this.stripe = stripe;
            if (DEBUG) {
                System.out.println("SerialExecutor created " + stripe);
            }
        }

        protected void finalize() throws Throwable {
            if (DEBUG) {
                System.out.println("SerialExecutor finalized " + this.stripe);
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(final Runnable r) {
            StripedExecutorService.this.lock.lock();
            try {
                this.tasks.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            r.run();
                        }
                        finally {
                            SerialExecutor.this.scheduleNext();
                        }
                    }
                });
                if (this.active == null) {
                    this.scheduleNext();
                }
            }
            finally {
                StripedExecutorService.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleNext() {
            StripedExecutorService.this.lock.lock();
            try {
                this.active = (Runnable)this.tasks.poll();
                if (this.active != null) {
                    StripedExecutorService.this.executor.execute(this.active);
                    StripedExecutorService.this.terminating.signalAll();
                } else {
                    StripedExecutorService.this.removeEmptySerialExecutor(this.stripe, this);
                }
            }
            finally {
                StripedExecutorService.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            StripedExecutorService.this.lock.lock();
            try {
                boolean bl = this.active == null && this.tasks.isEmpty();
                return bl;
            }
            finally {
                StripedExecutorService.this.lock.unlock();
            }
        }

        public String toString() {
            assert (StripedExecutorService.this.lock.isHeldByCurrentThread());
            return "SerialExecutor: active=" + this.active + ", " + "tasks=" + this.tasks;
        }
    }

    private static enum State {
        RUNNING,
        SHUTDOWN;

    }
}

