/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.eclipse.californium.elements.tcp.TcpClientConnector;

public class TlsClientConnector
extends TcpClientConnector {
    private static final Logger LOGGER = Logger.getLogger(TlsClientConnector.class.getName());
    private final SSLContext sslContext;

    public TlsClientConnector(SSLContext sslContext, int numberOfThreads, int connectTimeoutMillis, int idleTimeout) {
        super(numberOfThreads, connectTimeoutMillis, idleTimeout);
        this.sslContext = sslContext;
    }

    public TlsClientConnector(int numberOfThreads, int connectTimeoutMillis, int idleTimeout) {
        super(numberOfThreads, connectTimeoutMillis, idleTimeout);
        try {
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(null, null, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to initialize SSL context", e);
        }
    }

    @Override
    protected void onNewChannelCreated(SocketAddress remote, Channel ch) {
        SSLEngine sslEngine = this.createSllEngine(remote);
        sslEngine.setUseClientMode(true);
        ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(sslEngine)});
    }

    @Override
    protected String getSupportedScheme() {
        return "coaps+tcp";
    }

    private SSLEngine createSllEngine(SocketAddress remoteAddress) {
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress remote = (InetSocketAddress)remoteAddress;
            LOGGER.log(Level.INFO, "Connection to inet {0}", remote);
            return this.sslContext.createSSLEngine(remote.getHostString(), remote.getPort());
        }
        LOGGER.log(Level.INFO, "Connection to {0}", remoteAddress);
        return this.sslContext.createSSLEngine();
    }
}

