/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.CorrelationContext;
import org.eclipse.californium.elements.CorrelationContextMatcher;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.tcp.CloseOnErrorHandler;
import org.eclipse.californium.elements.tcp.CloseOnIdleHandler;
import org.eclipse.californium.elements.tcp.DatagramFramer;
import org.eclipse.californium.elements.tcp.DispatchHandler;
import org.eclipse.californium.elements.tcp.NettyContextUtils;

public class TcpServerConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(TcpServerConnector.class.getName());
    private final String SUPPORTED_SCHEME = "coap+tcp";
    private final int numberOfThreads;
    private final int connectionIdleTimeoutSeconds;
    private final ConcurrentMap<SocketAddress, Channel> activeChannels = new ConcurrentHashMap<SocketAddress, Channel>();
    private RawDataChannel rawDataChannel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private URI listenUri;
    private InetSocketAddress localAddress;

    public TcpServerConnector(InetSocketAddress localAddress, int numberOfThreads, int idleTimeout) {
        this.numberOfThreads = numberOfThreads;
        this.connectionIdleTimeoutSeconds = idleTimeout;
        this.localAddress = localAddress;
        this.listenUri = this.getListenUri(localAddress);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.rawDataChannel == null) {
            throw new IllegalStateException("Cannot start without message handler.");
        }
        if (this.bossGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        if (this.workerGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(this.numberOfThreads);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.AUTO_READ, (Object)true)).childHandler((ChannelHandler)new ChannelRegistry());
        ChannelFuture channelFuture = bootstrap.bind((SocketAddress)this.localAddress).syncUninterruptibly();
        if (channelFuture.isSuccess() && 0 == this.localAddress.getPort()) {
            InetSocketAddress listenAddress = (InetSocketAddress)channelFuture.channel().localAddress();
            this.localAddress = new InetSocketAddress(this.localAddress.getAddress(), listenAddress.getPort());
            this.listenUri = this.getListenUri(this.localAddress);
        }
    }

    @Override
    public synchronized void stop() {
        if (null != this.bossGroup) {
            this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
            this.bossGroup = null;
        }
        if (null != this.workerGroup) {
            this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
            this.workerGroup = null;
        }
    }

    @Override
    public void destroy() {
        this.stop();
    }

    @Override
    public void send(RawData msg) {
        Channel channel = (Channel)this.activeChannels.get(msg.getInetSocketAddress());
        if (channel == null) {
            LOGGER.log(Level.WARNING, "Attempting to send message to an address without an active connection {0}", msg.getAddress());
            return;
        }
        CorrelationContext context = NettyContextUtils.buildCorrelationContext(channel);
        channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])msg.getBytes()));
        msg.onContextEstablished(context);
    }

    @Override
    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.rawDataChannel != null) {
            throw new IllegalStateException("RawDataChannel alrady set");
        }
        this.rawDataChannel = messageHandler;
    }

    @Override
    public synchronized void setCorrelationContextMatcher(CorrelationContextMatcher matcher) {
    }

    @Override
    public synchronized InetSocketAddress getAddress() {
        return this.localAddress;
    }

    protected void onNewChannelCreated(Channel ch) {
    }

    @Override
    public final boolean isSchemeSupported(String scheme) {
        return this.getSupportedScheme().equals(scheme);
    }

    @Override
    public final synchronized URI getUri() {
        return this.listenUri;
    }

    protected String getSupportedScheme() {
        return "coap+tcp";
    }

    private URI getListenUri(InetSocketAddress listenAddress) {
        return URI.create(String.format("%s://%s:%d", this.getSupportedScheme(), listenAddress.getHostString(), listenAddress.getPort()));
    }

    private class ChannelTracker
    extends ChannelInboundHandlerAdapter {
        private ChannelTracker() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            TcpServerConnector.this.activeChannels.put(ctx.channel().remoteAddress(), ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            TcpServerConnector.this.activeChannels.remove(ctx.channel().remoteAddress());
        }
    }

    private class ChannelRegistry
    extends ChannelInitializer<SocketChannel> {
        private ChannelRegistry() {
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            TcpServerConnector.this.onNewChannelCreated((Channel)ch);
            ch.pipeline().addLast(new ChannelHandler[]{new ChannelTracker()});
            ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, TcpServerConnector.this.connectionIdleTimeoutSeconds)});
            ch.pipeline().addLast(new ChannelHandler[]{new CloseOnIdleHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new DatagramFramer()});
            ch.pipeline().addLast(new ChannelHandler[]{new DispatchHandler(TcpServerConnector.this.rawDataChannel)});
            ch.pipeline().addLast(new ChannelHandler[]{new CloseOnErrorHandler()});
        }
    }
}

