/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.elements.CorrelationContext;

public class CorrelationContextUtil {
    private static final Logger LOGGER = Logger.getLogger(CorrelationContextUtil.class.getName());

    public static boolean match(String name, Set<String> keys, CorrelationContext context1, CorrelationContext context2) {
        boolean warn = LOGGER.isLoggable(Level.WARNING);
        boolean info = LOGGER.isLoggable(Level.FINEST);
        boolean matchAll = true;
        for (String key : keys) {
            String value2;
            boolean match;
            String value1 = context1.get(key);
            boolean bl = match = value1 == (value2 = context2.get(key)) || null != value1 && value1.equals(value2);
            if (!match && !warn) {
                return false;
            }
            if (!match) {
                LOGGER.log(Level.WARNING, "{0}, {1}: \"{2}\" != \"{3}\"", new Object[]{name, key, value1, value2});
            } else if (info) {
                LOGGER.log(Level.FINEST, "{0}, {1}: \"{2}\" == \"{3}\"", new Object[]{name, key, value1, value2});
            }
            matchAll = matchAll && match;
        }
        return matchAll;
    }
}

