/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.tcp.CloseOnIdleHandler;
import org.eclipse.californium.elements.tcp.DatagramFramer;
import org.eclipse.californium.elements.tcp.DispatchHandler;

public class TcpServerConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(TcpServerConnector.class.getName());
    private final int numberOfThreads;
    private final InetSocketAddress localAddress;
    private final int connectionIdleTimeoutSeconds;
    private final ConcurrentMap<SocketAddress, Channel> activeChannels = new ConcurrentHashMap<SocketAddress, Channel>();
    private RawDataChannel rawDataChannel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public TcpServerConnector(InetSocketAddress localAddress, int idleTimeout, int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
        this.connectionIdleTimeoutSeconds = idleTimeout;
        this.localAddress = localAddress;
    }

    @Override
    public void start() throws IOException {
        if (this.rawDataChannel == null) {
            throw new IllegalStateException("Cannot start without message handler.");
        }
        if (this.bossGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        if (this.workerGroup != null) {
            throw new IllegalStateException("Connector already started");
        }
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup(this.numberOfThreads);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.AUTO_READ, (Object)true)).childHandler((ChannelHandler)new ChannelRegistry());
        bootstrap.bind((SocketAddress)this.localAddress).syncUninterruptibly();
    }

    @Override
    public void stop() {
        this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
        this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
        this.workerGroup = null;
        this.bossGroup = null;
    }

    @Override
    public void destroy() {
        this.stop();
    }

    @Override
    public void send(RawData msg) {
        Channel channel = (Channel)this.activeChannels.get(msg.getInetSocketAddress());
        if (channel == null) {
            LOGGER.log(Level.WARNING, "Attempting to send message to an address without an active connection {0}", msg.getAddress());
            return;
        }
        channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])msg.getBytes()));
    }

    @Override
    public void setRawDataReceiver(RawDataChannel messageHandler) {
        if (this.rawDataChannel != null) {
            throw new IllegalStateException("RawDataChannel alrady set");
        }
        this.rawDataChannel = messageHandler;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.localAddress;
    }

    protected void onNewChannelCreated(Channel ch) {
    }

    @Override
    public boolean isSchemeSupported(String scheme) {
        return "coap+tcp".equals(scheme);
    }

    private class ChannelTracker
    extends ChannelInboundHandlerAdapter {
        private ChannelTracker() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            TcpServerConnector.this.activeChannels.put(ctx.channel().remoteAddress(), ctx.channel());
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            TcpServerConnector.this.activeChannels.remove(ctx.channel().remoteAddress());
        }
    }

    private class ChannelRegistry
    extends ChannelInitializer<SocketChannel> {
        private ChannelRegistry() {
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            TcpServerConnector.this.onNewChannelCreated((Channel)ch);
            ch.pipeline().addLast(new ChannelHandler[]{new ChannelTracker()});
            ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, TcpServerConnector.this.connectionIdleTimeoutSeconds)});
            ch.pipeline().addLast(new ChannelHandler[]{new CloseOnIdleHandler()});
            ch.pipeline().addLast(new ChannelHandler[]{new DatagramFramer()});
            ch.pipeline().addLast(new ChannelHandler[]{new DispatchHandler(TcpServerConnector.this.rawDataChannel)});
            ch.pipeline().addLast(new ChannelHandler[]{new CloseOnIdleHandler()});
        }
    }
}

