/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import org.eclipse.californium.elements.CorrelationContext;
import org.eclipse.californium.elements.MessageCallback;

public final class RawData {
    public final byte[] bytes;
    private InetSocketAddress address;
    private boolean multicast;
    private Principal senderIdentity;
    private CorrelationContext correlationContext;
    private MessageCallback callback;

    public RawData(byte[] data) {
        this(data, null, 0, null, false);
    }

    public RawData(byte[] data, InetSocketAddress address) {
        this(data, address, null, false);
    }

    public RawData(byte[] data, InetSocketAddress address, Principal clientIdentity) {
        this(data, address, clientIdentity, false);
    }

    public RawData(byte[] data, InetAddress address, int port) {
        this(data, address, port, null, false);
    }

    public RawData(byte[] data, InetAddress address, int port, Principal clientIdentity) {
        this(data, address, port, clientIdentity, false);
    }

    public RawData(byte[] data, InetSocketAddress address, boolean multicast) {
        this(data, address, null, multicast);
    }

    public RawData(byte[] data, InetSocketAddress address, Principal clientIdentity, boolean multicast) {
        this(data, address, clientIdentity, null, multicast);
    }

    private RawData(byte[] data, InetSocketAddress address, Principal clientIdentity, CorrelationContext correlationContext, boolean multicast) {
        if (data == null) {
            throw new NullPointerException("Data must not be null");
        }
        if (address == null) {
            throw new NullPointerException("Address must not be null");
        }
        this.bytes = data;
        this.address = address;
        this.senderIdentity = clientIdentity;
        this.correlationContext = correlationContext;
        this.multicast = multicast;
    }

    public RawData(byte[] data, InetAddress address, int port, boolean multicast) {
        this(data, address, port, null, multicast);
    }

    public RawData(byte[] data, InetAddress address, int port, Principal clientIdentity, boolean multicast) {
        this(data, new InetSocketAddress(address, port), clientIdentity, multicast);
    }

    public static RawData inbound(byte[] data, InetSocketAddress address, Principal clientIdentity, CorrelationContext correlationContext, boolean isMulticast) {
        return new RawData(data, address, clientIdentity, correlationContext, isMulticast);
    }

    public static RawData outbound(byte[] data, InetSocketAddress address, MessageCallback callback, boolean useMulticast) {
        RawData result = new RawData(data, address);
        result.callback = callback;
        result.multicast = useMulticast;
        return result;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public int getSize() {
        return this.bytes.length;
    }

    public InetAddress getAddress() {
        return this.address.getAddress();
    }

    public void setAddress(InetAddress newAddress) {
        this.address = new InetSocketAddress(newAddress, this.address.getPort());
    }

    public int getPort() {
        return this.address.getPort();
    }

    public void setPort(int port) {
        this.address = new InetSocketAddress(this.address.getAddress(), port);
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public void setMulticast(boolean multicast) {
        this.multicast = multicast;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.address;
    }

    public Principal getSenderIdentity() {
        return this.senderIdentity;
    }

    public CorrelationContext getCorrelationContext() {
        return this.correlationContext;
    }

    public MessageCallback getMessageCallback() {
        return this.callback;
    }

    public boolean isSecure() {
        return this.correlationContext != null && this.correlationContext.get("DTLS_SESSION_ID") != null;
    }
}

