/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import org.eclipse.californium.elements.UDPConnector;

public class UdpMulticastConnector
extends UDPConnector {
    private InetAddress[] multicastGroups;

    public UdpMulticastConnector(InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        super(localAddress);
        this.multicastGroups = multicastGroups;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        MulticastSocket socket = new MulticastSocket(this.localAddr);
        for (InetAddress group : this.multicastGroups) {
            socket.joinGroup(group);
        }
        this.init(socket);
    }
}

