/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;

public class RawData {
    public final byte[] bytes;
    private InetSocketAddress address;
    private boolean multicast;
    private Principal senderIdentity;

    public RawData(byte[] data) {
        this(data, null, 0, null, false);
    }

    public RawData(byte[] data, InetSocketAddress address) {
        this(data, address, null, false);
    }

    public RawData(byte[] data, InetSocketAddress address, Principal clientIdentity) {
        this(data, address, clientIdentity, false);
    }

    public RawData(byte[] data, InetAddress address, int port) {
        this(data, address, port, null, false);
    }

    public RawData(byte[] data, InetAddress address, int port, Principal clientIdentity) {
        this(data, address, port, clientIdentity, false);
    }

    public RawData(byte[] data, InetSocketAddress address, boolean multicast) {
        this(data, address, null, multicast);
    }

    public RawData(byte[] data, InetSocketAddress address, Principal clientIdentity, boolean multicast) {
        if (data == null) {
            throw new NullPointerException("Data must not be null");
        }
        if (address == null) {
            throw new NullPointerException("Address must not be null");
        }
        this.bytes = data;
        this.address = address;
        this.senderIdentity = clientIdentity;
        this.multicast = multicast;
    }

    public RawData(byte[] data, InetAddress address, int port, boolean multicast) {
        this(data, address, port, null, multicast);
    }

    public RawData(byte[] data, InetAddress address, int port, Principal clientIdentity, boolean multicast) {
        this(data, new InetSocketAddress(address, port), clientIdentity, multicast);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public int getSize() {
        return this.bytes.length;
    }

    public InetAddress getAddress() {
        return this.address.getAddress();
    }

    public void setAddress(InetAddress newAddress) {
        this.address = new InetSocketAddress(newAddress, this.address.getPort());
    }

    public int getPort() {
        return this.address.getPort();
    }

    public void setPort(int port) {
        this.address = new InetSocketAddress(this.address.getAddress(), port);
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    public void setMulticast(boolean multicast) {
        this.multicast = multicast;
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.address;
    }

    public Principal getSenderIdentity() {
        return this.senderIdentity;
    }
}

