/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapExchange;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.server.resources.Resource;

public class ObserveReset
extends CoapResource {
    private static final String URI_QUERY_OPTION_NOTFOUND = "notfound";

    public ObserveReset() {
        super("obs-reset");
    }

    @Override
    public void handlePOST(CoapExchange exchange) {
        if (exchange.getRequestText().equals("sesame")) {
            System.out.println("obs-reset received POST. Clearing observers");
            CoAP.ResponseCode code = exchange.getQueryParameter(URI_QUERY_OPTION_NOTFOUND) != null ? CoAP.ResponseCode.NOT_FOUND : null;
            for (Resource child : this.getParent().getChildren()) {
                if (!child.isObservable() || !(child instanceof CoapResource)) continue;
                ((CoapResource)child).clearAndNotifyObserveRelations(code);
            }
            exchange.respond(CoAP.ResponseCode.CHANGED);
        } else {
            exchange.respond(CoAP.ResponseCode.FORBIDDEN);
        }
    }
}

