/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import com.upokecenter.cbor.CBORObject;
import org.eclipse.californium.core.CoapExchange;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;

public class MultiFormat
extends CoapResource {
    public MultiFormat() {
        super("multi-format");
        this.getAttributes().setTitle("Resource that exists in different content formats (text/plain utf8 and application/xml)");
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(41);
        this.getAttributes().addContentType(50);
        this.getAttributes().addContentType(60);
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        String format = null;
        switch (exchange.getRequestOptions().getAccept()) {
            case -1: 
            case 0: {
                response.getOptions().setContentFormat(0);
                format = "Status type: \"%s\"\nCode: \"%s\"\nMID: %d\nAccept: %d";
                break;
            }
            case 41: {
                response.getOptions().setContentFormat(41);
                format = "<msg type=\"%s\" code=\"%s\" mid=\"%d\" accept=\"%d\" />";
                break;
            }
            case 50: {
                response.getOptions().setContentFormat(50);
                format = "{ \"type\":\"%s\", \"code\":\"%s\", \"mid\":%d, \"accept\":%d }";
                break;
            }
            case 60: {
                response.getOptions().setContentFormat(60);
                CBORObject map = CBORObject.NewMap();
                map.set(CBORObject.FromObject("type"), CBORObject.FromObject(request.getType().name()));
                map.set(CBORObject.FromObject("code"), CBORObject.FromObject(request.getCode().name()));
                map.set(CBORObject.FromObject("mid"), CBORObject.FromObject(request.getMID()));
                map.set(CBORObject.FromObject("accept"), CBORObject.FromObject(request.getOptions().getAccept()));
                response.setPayload(map.EncodeToBytes());
                break;
            }
            default: {
                response = new Response(CoAP.ResponseCode.NOT_ACCEPTABLE);
                format = "text/plain, application/xml, application/json, or application/cbor only";
            }
        }
        if (format != null) {
            response.setPayload(String.format(format, new Object[]{request.getType(), request.getCode(), request.getMID(), request.getOptions().getAccept()}));
        }
        exchange.respond(response);
    }
}

