/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.resources;

import org.eclipse.californium.core.CoapExchange;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;

public class Hono
extends CoapResource {
    public Hono(String name) {
        super(name, false);
        this.getAttributes().setTitle("Hono test request for " + name);
        this.addSupportedContentFormats(50, 0, 42);
    }

    @Override
    public void handlePOST(CoapExchange exchange) {
        int accept = exchange.getRequestOptions().getAccept();
        if (accept == 0 || accept == -1) {
            exchange.respond(CoAP.ResponseCode.CHANGED, this.getName() + " published!", 0);
        } else if (accept == 50) {
            exchange.respond(CoAP.ResponseCode.CHANGED, "{ \"type\" : \"" + this.getName() + "\", \"msg\" : \"published!\" }", 50);
        } else if (accept == 42) {
            exchange.respond(CoAP.ResponseCode.CHANGED, (this.getName() + " published!").getBytes(), 42);
        } else {
            String ct = MediaTypeRegistry.toString(accept);
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE, "Type \"" + ct + "\" is not supported for this resource!", 0);
        }
    }
}

