/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.TlsEndpointContext;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.tcp.netty.TcpContextUtil;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsContextUtil
extends TcpContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TlsContextUtil.class);
    private static final AttributeKey<Long> tlsConnectTimestamp = AttributeKey.newInstance("tls_connect_millis");
    private static final AttributeKey<Principal> tlsPrincipal = AttributeKey.newInstance("tls_principal");
    private static final AttributeKey<String> tlsSessionId = AttributeKey.newInstance("tls_session_id");
    private final CertificateAuthenticationMode clientAuthMode;

    public TlsContextUtil(CertificateAuthenticationMode clientAuthMode) {
        this.clientAuthMode = clientAuthMode;
    }

    @Override
    public EndpointContext buildEndpointContext(Channel channel) {
        InetSocketAddress address = (InetSocketAddress)channel.remoteAddress();
        String id = channel.id().asShortText();
        SslHandler sslHandler = channel.pipeline().get(SslHandler.class);
        if (sslHandler == null) {
            throw new IllegalStateException("Missing SslHandler for " + id + "!");
        }
        SSLEngine sslEngine = sslHandler.engine();
        SSLSession sslSession = sslEngine.getSession();
        if (sslSession != null) {
            long accessTime = sslSession.getLastAccessedTime();
            Principal principal = null;
            String sslId = null;
            Long contextAccessTime = channel.attr(tlsConnectTimestamp).get();
            if (contextAccessTime == null || accessTime != contextAccessTime) {
                byte[] sessionId;
                boolean checkKerberos = false;
                if (this.clientAuthMode.useCertificateRequest()) {
                    try {
                        Certificate[] peerCertificateChain = sslSession.getPeerCertificates();
                        if (peerCertificateChain != null && peerCertificateChain.length != 0) {
                            principal = X509CertPath.fromCertificatesChain(peerCertificateChain);
                        } else {
                            checkKerberos = true;
                        }
                    }
                    catch (SSLPeerUnverifiedException e1) {
                        checkKerberos = true;
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn("TLS({}) failed to extract principal {}", (Object)id, (Object)e.getMessage());
                    }
                    if (checkKerberos) {
                        try {
                            principal = sslSession.getPeerPrincipal();
                        }
                        catch (SSLPeerUnverifiedException e2) {
                            if (this.clientAuthMode == CertificateAuthenticationMode.NEEDED) {
                                LOGGER.warn("TLS({}) failed to verify principal, {}", (Object)id, (Object)e2.getMessage());
                            }
                            LOGGER.trace("TLS({}) failed to verify principal, {}", (Object)id, (Object)e2.getMessage());
                        }
                    }
                    if (principal != null) {
                        LOGGER.debug("TLS({}) Principal {}", (Object)id, (Object)principal.getName());
                    } else if (this.clientAuthMode == CertificateAuthenticationMode.NEEDED) {
                        LOGGER.warn("TLS({}) principal missing", (Object)id);
                    } else {
                        LOGGER.trace("TLS({}) principal missing", (Object)id);
                    }
                }
                if ((sessionId = sslSession.getId()) != null && sessionId.length > 0) {
                    sslId = StringUtil.byteArray2HexString(sessionId, '\u0000', 0);
                    channel.attr(tlsConnectTimestamp).set(accessTime);
                    channel.attr(tlsPrincipal).set(principal);
                    channel.attr(tlsSessionId).set(sslId);
                }
            } else {
                principal = channel.attr(tlsPrincipal).get();
                sslId = channel.attr(tlsSessionId).get();
            }
            if (sslId != null) {
                String cipherSuite = sslSession.getCipherSuite();
                LOGGER.debug("TLS({},{},{})", id, StringUtil.trunc(sslId, 14), cipherSuite);
                return new TlsEndpointContext(address, principal, id, sslId, cipherSuite, accessTime);
            }
        }
        throw new IllegalStateException("TLS handshake " + id + " not ready!");
    }

    public static String[] getWeakCipherSuites(SSLContext sslContext) {
        if (!JceProviderUtil.hasStrongEncryption() && JceProviderUtil.usesBouncyCastle() && JceProviderUtil.getProviderVersion().compareTo("1.70") < 0) {
            return SslContextUtil.getWeakCipherSuites(sslContext);
        }
        return null;
    }
}

