/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server;

import org.eclipse.californium.core.coap.CoAP;

public class DelivererException
extends Exception {
    private static final long serialVersionUID = 123L;
    private final CoAP.ResponseCode response;
    private final boolean internal;

    public DelivererException(CoAP.ResponseCode response, String message) {
        this(response, message, false);
    }

    public DelivererException(CoAP.ResponseCode response, String message, boolean internal) {
        super(message);
        if (!response.isClientError() && !response.isServerError()) {
            throw new IllegalArgumentException("response code " + (Object)((Object)response) + " must be an error-code!");
        }
        this.response = response;
        this.internal = internal;
    }

    public CoAP.ResponseCode getErrorResponseCode() {
        return this.response;
    }

    public boolean isInternal() {
        return this.internal;
    }
}

