/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.CoAPMessageFormatException;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.coap.option.OptionRegistry;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapStackFactory;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointContextMatcherFactory;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.core.network.EndpointObserver;
import org.eclipse.californium.core.network.EndpointReceiver;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.InMemoryMessageExchangeStore;
import org.eclipse.californium.core.network.Matcher;
import org.eclipse.californium.core.network.MessageExchangeStore;
import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.RandomTokenGenerator;
import org.eclipse.californium.core.network.TcpMatcher;
import org.eclipse.californium.core.network.TokenGenerator;
import org.eclipse.californium.core.network.UdpMatcher;
import org.eclipse.californium.core.network.deduplication.NoDeduplicator;
import org.eclipse.californium.core.network.interceptors.MalformedMessageInterceptor;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;
import org.eclipse.californium.core.network.serialization.DataParser;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.core.network.serialization.TcpDataParser;
import org.eclipse.californium.core.network.serialization.TcpDataSerializer;
import org.eclipse.californium.core.network.serialization.UdpDataParser;
import org.eclipse.californium.core.network.serialization.UdpDataSerializer;
import org.eclipse.californium.core.network.stack.CoapStack;
import org.eclipse.californium.core.network.stack.CoapTcpStack;
import org.eclipse.californium.core.network.stack.CoapUdpStack;
import org.eclipse.californium.core.observe.InMemoryObservationStore;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.EndpointIdentityResolver;
import org.eclipse.californium.elements.MessageCallback;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.UdpMulticastConnector;
import org.eclipse.californium.elements.auth.ApplicationAuthorizer;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.ProtocolScheduledExecutorService;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapEndpoint
implements Endpoint,
Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapEndpoint.class);
    private static final Logger LOGGER_BAN = LoggerFactory.getLogger("org.eclipse.californium.ban");
    private static final AtomicBoolean LOGGER_BAN_STARTED = new AtomicBoolean();
    protected final CoapStack coapstack;
    private final Connector connector;
    private final ApplicationAuthorizer authorizer;
    private final String scheme;
    private final int multicastBaseMid;
    private final boolean useRequestOffloading;
    private final Configuration config;
    private final EndpointIdentityResolver identityResolver;
    private final Matcher matcher;
    private final DataSerializer serializer;
    private final DataParser parser;
    private final MessageExchangeStore exchangeStore;
    private final ObservationStore observationStore;
    private final String tag;
    private ProtocolScheduledExecutorService executor;
    private volatile boolean started;
    private List<EndpointObserver> observers = new CopyOnWriteArrayList<EndpointObserver>();
    private List<MessageInterceptor> interceptors = new CopyOnWriteArrayList<MessageInterceptor>();
    private List<MessageInterceptor> postProcessInterceptors = new CopyOnWriteArrayList<MessageInterceptor>();
    private List<MalformedMessageInterceptor> malformedMessageCounters = new CopyOnWriteArrayList<MalformedMessageInterceptor>();
    private List<BiConsumer<Request, Response>> notificationListeners = new CopyOnWriteArrayList<BiConsumer<Request, Response>>();
    private ScheduledFuture<?> statusLogger;
    private final EndpointReceiver endpointStackReceiver = new EndpointReceiver(){

        @Override
        public void receiveRequest(Exchange exchange, Request request) {
            if (CoapEndpoint.this.started) {
                exchange.setEndpoint(CoapEndpoint.this);
                CoapEndpoint.this.coapstack.receiveRequest(exchange, request);
                CoapEndpoint.this.notifyReceive((List<MessageInterceptor>)CoapEndpoint.this.postProcessInterceptors, request);
            }
        }

        @Override
        public void receiveResponse(Exchange exchange, Response response) {
            if (CoapEndpoint.this.started) {
                if (exchange != null && !response.isCanceled()) {
                    exchange.setEndpoint(CoapEndpoint.this);
                    if (!exchange.isNotification()) {
                        response.setApplicationRttNanos(exchange.calculateApplicationRtt());
                        response.setTransmissionRttNanos(exchange.calculateTransmissionRtt());
                    }
                    CoapEndpoint.this.coapstack.receiveResponse(exchange, response);
                }
                CoapEndpoint.this.notifyReceive((List<MessageInterceptor>)CoapEndpoint.this.postProcessInterceptors, response);
            }
        }

        @Override
        public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
            if (CoapEndpoint.this.started) {
                if (exchange != null && !message.isCanceled()) {
                    Response response;
                    exchange.setEndpoint(CoapEndpoint.this);
                    if (!exchange.isOfLocalOrigin() && (response = exchange.getCurrentResponse()) != null && response.isConfirmable()) {
                        response.setTransmissionRttNanos(exchange.calculateTransmissionRtt());
                    }
                    CoapEndpoint.this.coapstack.receiveEmptyMessage(exchange, message);
                }
                CoapEndpoint.this.notifyReceive((List<MessageInterceptor>)CoapEndpoint.this.postProcessInterceptors, message);
            }
        }

        @Override
        public void reject(Message message) {
            if (CoapEndpoint.this.started) {
                EmptyMessage rst = EmptyMessage.newRST(message);
                CoapEndpoint.this.coapstack.sendEmptyMessage(null, rst);
            }
        }
    };
    public static final CoapStackFactory STANDARD_COAP_STACK_FACTORY = new CoapStackFactory(){

        @Override
        public CoapStack createCoapStack(String protocol, String tag, Configuration config, EndpointContextMatcher matchingStrategy, Outbox outbox, Object customStackArgument) {
            if (CoAP.isTcpProtocol(protocol)) {
                return new CoapTcpStack(tag, config, matchingStrategy, outbox);
            }
            return new CoapUdpStack(tag, config, matchingStrategy, outbox);
        }
    };
    private static CoapStackFactory defaultCoapStackFactory;

    protected CoapEndpoint(Connector connector, Configuration config, TokenGenerator tokenGenerator, ObservationStore store, MessageExchangeStore exchangeStore, EndpointContextMatcher endpointContextMatcher, DataSerializer serializer, DataParser parser, String loggingTag, CoapStackFactory coapStackFactory, Object customStackArgument) {
        if (LOGGER_BAN.isInfoEnabled() && LOGGER_BAN_STARTED.compareAndSet(false, true)) {
            LOGGER_BAN.info("Started.");
        }
        this.config = config;
        this.connector = connector;
        this.authorizer = connector instanceof ApplicationAuthorizer ? (ApplicationAuthorizer)((Object)connector) : null;
        this.connector.setRawDataReceiver(new InboxImpl());
        this.scheme = CoAP.getSchemeForProtocol(connector.getProtocol());
        this.multicastBaseMid = config.get(CoapConfig.MULTICAST_BASE_MID);
        this.tag = StringUtil.normalizeLoggingTag(loggingTag);
        if (tokenGenerator == null) {
            tokenGenerator = new RandomTokenGenerator(config);
        }
        if (coapStackFactory == null) {
            coapStackFactory = CoapEndpoint.getDefaultCoapStackFactory();
        }
        this.exchangeStore = null != exchangeStore ? exchangeStore : new InMemoryMessageExchangeStore(this.tag, config, tokenGenerator);
        ObservationStore observationStore = this.observationStore = null != store ? store : new InMemoryObservationStore(config);
        if (null == endpointContextMatcher) {
            endpointContextMatcher = EndpointContextMatcherFactory.create(connector, config);
        }
        this.identityResolver = endpointContextMatcher;
        this.connector.setEndpointContextMatcher(endpointContextMatcher);
        LOGGER.info("{}{} uses {}", this.tag, this.getClass().getSimpleName(), endpointContextMatcher.getName());
        this.coapstack = coapStackFactory.createCoapStack(connector.getProtocol(), this.tag, config, endpointContextMatcher, new OutboxImpl(), customStackArgument);
        if (CoAP.isTcpProtocol(connector.getProtocol())) {
            this.useRequestOffloading = false;
            this.matcher = new TcpMatcher(config, (BiConsumer<Request, Response>)new NotificationDispatcher(), tokenGenerator, this.observationStore, this.exchangeStore, endpointContextMatcher, (Executor)this);
            this.serializer = serializer != null ? serializer : new TcpDataSerializer();
            this.parser = parser != null ? parser : new TcpDataParser();
        } else {
            this.useRequestOffloading = config.get(CoapConfig.USE_MESSAGE_OFFLOADING);
            this.matcher = new UdpMatcher(config, (BiConsumer<Request, Response>)new NotificationDispatcher(), tokenGenerator, this.observationStore, this.exchangeStore, this, endpointContextMatcher);
            this.serializer = serializer != null ? serializer : new UdpDataSerializer();
            this.parser = parser != null ? parser : new UdpDataParser();
        }
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.started) {
            LOGGER.debug("{}Endpoint at {} is already started", (Object)this.tag, (Object)this.getUri());
            return;
        }
        if (!this.coapstack.hasDeliverer()) {
            this.setMessageDeliverer(new EndpointManager.ClientMessageDeliverer());
        }
        if (this.executor == null) {
            LOGGER.info("{}Endpoint [{}] requires an executor to start, using default single-threaded daemon executor", (Object)this.tag, (Object)this.getUri());
            final ProtocolScheduledExecutorService executorService = ExecutorsUtil.newSingleThreadedProtocolExecutor(new DaemonThreadFactory(":CoapEndpoint-" + this.connector + '#'));
            this.setExecutor(executorService);
            this.addObserver(new EndpointObserver(){

                @Override
                public void destroyed(Endpoint endpoint) {
                    ExecutorsUtil.shutdownExecutorGracefully(1000L, executorService);
                }
            });
        }
        try {
            LOGGER.debug("{}Starting endpoint at {}", (Object)this.tag, (Object)this.getUri());
            this.matcher.start();
            this.connector.start();
            this.coapstack.start();
            this.started = true;
            for (EndpointObserver obs : this.observers) {
                obs.started(this);
            }
            LOGGER.info("{}Started endpoint at {}", (Object)this.tag, (Object)this.getUri());
        }
        catch (IOException e) {
            this.stop();
            throw e;
        }
    }

    @Override
    public synchronized void stop() {
        URI uri = this.getUri();
        if (!this.started) {
            LOGGER.debug("{}Endpoint at {} is already stopped", (Object)this.tag, (Object)uri);
        } else {
            LOGGER.debug("{}Stopping endpoint at {}", (Object)this.tag, (Object)uri);
            this.started = false;
            if (this.statusLogger != null) {
                this.statusLogger.cancel(false);
                this.statusLogger = null;
            }
            this.connector.stop();
            this.matcher.stop();
            for (EndpointObserver obs : this.observers) {
                obs.stopped(this);
            }
            LOGGER.debug("{}Stopped endpoint at {}", (Object)this.tag, (Object)uri);
        }
    }

    @Override
    public synchronized void destroy() {
        LOGGER.info("{}Destroying endpoint at {}", (Object)this.tag, (Object)this.getUri());
        if (this.started) {
            this.stop();
        }
        this.connector.destroy();
        this.coapstack.destroy();
        for (EndpointObserver obs : this.observers) {
            obs.destroyed(this);
        }
    }

    @Override
    public void clear() {
        this.matcher.clear();
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setExecutor(ProtocolScheduledExecutorService executor) {
        if (executor == null) {
            throw new NullPointerException("executor must not be null!");
        }
        if (this.executor == executor) {
            return;
        }
        if (this.started) {
            throw new IllegalStateException("endpoint already started!");
        }
        this.executor = executor;
        this.coapstack.setExecutor(executor);
        this.exchangeStore.setExecutor(executor.getBackgroundExecutor());
        this.observationStore.setExecutor(executor.getBackgroundExecutor());
    }

    @Override
    public ProtocolScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public void addNotificationListener(BiConsumer<Request, Response> listener) {
        this.notificationListeners.add(listener);
    }

    @Override
    public void removeNotificationListener(BiConsumer<Request, Response> listener) {
        this.notificationListeners.remove(listener);
    }

    @Override
    public void addObserver(EndpointObserver observer) {
        this.observers.add(observer);
        if (this.isStarted()) {
            observer.started(this);
        }
    }

    @Override
    public void removeObserver(EndpointObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void addInterceptor(MessageInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public void removeInterceptor(MessageInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    @Override
    public List<MessageInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    @Override
    public void addPostProcessInterceptor(MessageInterceptor interceptor) {
        this.postProcessInterceptors.add(interceptor);
        if (interceptor instanceof MalformedMessageInterceptor) {
            this.malformedMessageCounters.add((MalformedMessageInterceptor)interceptor);
        }
    }

    @Override
    public void removePostProcessInterceptor(MessageInterceptor interceptor) {
        this.postProcessInterceptors.remove(interceptor);
        if (interceptor instanceof MalformedMessageInterceptor) {
            this.malformedMessageCounters.remove((MalformedMessageInterceptor)interceptor);
        }
    }

    @Override
    public List<MessageInterceptor> getPostProcessInterceptors() {
        return Collections.unmodifiableList(this.postProcessInterceptors);
    }

    @Override
    public void sendRequest(final Request request) {
        Object identity;
        if (!this.started) {
            request.cancel();
            return;
        }
        InetSocketAddress destinationAddress = request.getDestinationContext().getPeerAddress();
        int mid = request.getMID();
        if (request.isMulticast()) {
            if (0 >= this.multicastBaseMid) {
                LOGGER.warn("{}multicast messaging to destination {} is not enabled! Please enable it configuring \"" + CoapConfig.MULTICAST_BASE_MID.getKey() + "\" greater than 0", (Object)this.tag, StringUtil.toLog(destinationAddress));
                request.setSendError(new IllegalArgumentException("multicast is not enabled!"));
                return;
            }
            if (request.getType() == CoAP.Type.CON) {
                LOGGER.warn("{}CON request to multicast destination {} is not allowed, as per RFC 7252, 8.1, a client MUST use NON message type for multicast requests", (Object)this.tag, StringUtil.toLog(destinationAddress));
                request.setSendError(new IllegalArgumentException("multicast is not supported for CON!"));
                return;
            }
            if (request.hasMID() && mid < this.multicastBaseMid) {
                LOGGER.warn("{}multicast request to group {} has mid {} which is not in the MULTICAST_MID range [{}-65535]", this.tag, StringUtil.toLog(destinationAddress), mid, this.multicastBaseMid);
                request.setSendError(new IllegalArgumentException("multicast mid is not in range [" + this.multicastBaseMid + "-65535]"));
                return;
            }
        } else if (this.isMulticastMid(mid)) {
            LOGGER.warn("{}request to {} has mid {}, which is in the MULTICAST_MID range [{}-65535]", this.tag, StringUtil.toLog(destinationAddress), mid, this.multicastBaseMid);
            request.setSendError(new IllegalArgumentException("unicast mid is in multicast range [" + this.multicastBaseMid + "-65535]"));
            return;
        }
        if (destinationAddress.isUnresolved()) {
            String addr = StringUtil.toDisplayString(destinationAddress);
            LOGGER.warn("{}request has unresolved destination address {}", (Object)this.tag, (Object)addr);
            request.setSendError(new IllegalArgumentException(addr + " is a unresolved address!"));
            return;
        }
        if (request.isSent()) {
            IllegalArgumentException exception = new IllegalArgumentException("Request already sent!");
            LOGGER.error("{}request was already sent!", (Object)this.tag, (Object)exception);
            request.setSendError(exception);
            return;
        }
        try {
            identity = this.identityResolver.getEndpointIdentity(request.getDestinationContext());
        }
        catch (IllegalArgumentException ex) {
            if (request.getRawCode() == 0) {
                identity = request.getDestinationContext().getPeerAddress();
            }
            throw ex;
        }
        final Exchange exchange = new Exchange(request, identity, Exchange.Origin.LOCAL, this.executor);
        exchange.setEndpoint(this);
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                CoapEndpoint.this.coapstack.sendRequest(exchange, request);
            }
        });
    }

    @Override
    public void sendResponse(final Exchange exchange, final Response response) {
        if (!this.started) {
            response.cancel();
            return;
        }
        if (response.isSent()) {
            IllegalArgumentException exception = new IllegalArgumentException("Response already sent!");
            LOGGER.error("{}response was already sent!", (Object)this.tag, (Object)exception);
            response.setSendError(exception);
            return;
        }
        if (exchange.checkOwner()) {
            this.coapstack.sendResponse(exchange, response);
        } else {
            exchange.execute(new Runnable(){

                @Override
                public void run() {
                    CoapEndpoint.this.coapstack.sendResponse(exchange, response);
                }
            });
        }
    }

    @Override
    public void sendEmptyMessage(final Exchange exchange, final EmptyMessage message) {
        if (!this.started) {
            message.cancel();
            return;
        }
        if (message.isSent()) {
            IllegalArgumentException exception = new IllegalArgumentException("Empty message already sent!");
            LOGGER.error("{}empty message was already sent!", (Object)this.tag, (Object)exception);
            message.setSendError(exception);
            return;
        }
        if (exchange.checkOwner()) {
            this.coapstack.sendEmptyMessage(exchange, message);
        } else {
            exchange.execute(new Runnable(){

                @Override
                public void run() {
                    CoapEndpoint.this.coapstack.sendEmptyMessage(exchange, message);
                }
            });
        }
    }

    @Override
    public void setMessageDeliverer(MessageDeliverer deliverer) {
        this.coapstack.setDeliverer(deliverer);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.connector.getAddress();
    }

    @Override
    public URI getUri() {
        try {
            InetSocketAddress address = this.getAddress();
            String hostname = StringUtil.getUriHostname(address.getAddress());
            return new URI(this.scheme, null, hostname, address.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("{}URI", (Object)this.tag, (Object)e);
            return null;
        }
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    public Connector getConnector() {
        return this.connector;
    }

    private void notifySend(List<MessageInterceptor> list, Request request) {
        for (MessageInterceptor interceptor : list) {
            interceptor.sendRequest(request);
        }
    }

    private void notifySend(List<MessageInterceptor> list, Response response) {
        for (MessageInterceptor interceptor : list) {
            interceptor.sendResponse(response);
        }
    }

    private void notifySend(List<MessageInterceptor> list, EmptyMessage emptyMessage) {
        for (MessageInterceptor interceptor : list) {
            interceptor.sendEmptyMessage(emptyMessage);
        }
    }

    private void notifyReceive(List<MessageInterceptor> list, Request request) {
        for (MessageInterceptor interceptor : list) {
            interceptor.receiveRequest(request);
        }
    }

    private void notifyReceive(List<MessageInterceptor> list, Response response) {
        for (MessageInterceptor interceptor : list) {
            interceptor.receiveResponse(response);
        }
    }

    private void notifyReceive(List<MessageInterceptor> list, EmptyMessage emptyMessage) {
        for (MessageInterceptor interceptor : list) {
            interceptor.receiveEmptyMessage(emptyMessage);
        }
    }

    private void notifyReceiveMalformedMessage(RawData message) {
        for (MalformedMessageInterceptor counter : this.malformedMessageCounters) {
            counter.receivedMalformedMessage(message);
        }
    }

    private boolean isMulticastMid(int mid) {
        return 0 < this.multicastBaseMid && this.multicastBaseMid <= mid && mid <= 65535;
    }

    @Override
    public void cancelObservation(Token token) {
        this.matcher.cancelObserve(token);
    }

    @Override
    public ApplicationAuthorizer getApplicationAuthorizer() {
        return this.authorizer;
    }

    @Override
    public void execute(final Runnable task) {
        ProtocolScheduledExecutorService exchangeExecutor = this.executor;
        if (exchangeExecutor == null) {
            LOGGER.error("{}Executor not ready!", (Object)this.tag, (Object)new Throwable("execution failed!"));
        } else {
            try {
                exchangeExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            task.run();
                        }
                        catch (Throwable t) {
                            LOGGER.error("{}exception in protocol stage thread: {}", CoapEndpoint.this.tag, t.getMessage(), t);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.debug("{} execute:", (Object)this.tag, (Object)e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static synchronized CoapStackFactory getDefaultCoapStackFactory() {
        if (defaultCoapStackFactory == null) {
            defaultCoapStackFactory = STANDARD_COAP_STACK_FACTORY;
        }
        return defaultCoapStackFactory;
    }

    public static synchronized void setDefaultCoapStackFactory(CoapStackFactory newFactory) {
        if (defaultCoapStackFactory != null) {
            throw new IllegalStateException("Default coap-stack-factory already set!");
        }
        if (newFactory == null) {
            throw new NullPointerException("new coap-stack-factory must not be null!");
        }
        defaultCoapStackFactory = newFactory;
    }

    private class InboxImpl
    implements RawDataChannel {
        private InboxImpl() {
        }

        @Override
        public void receiveData(final RawData raw) {
            if (raw.getEndpointContext() == null) {
                throw new IllegalArgumentException("received message that does not have a endpoint context");
            }
            if (raw.getEndpointContext().getPeerAddress() == null) {
                throw new IllegalArgumentException("received message that does not have a source address");
            }
            if (raw.getEndpointContext().getPeerAddress().getPort() == 0) {
                throw new IllegalArgumentException("received message that does not have a source port");
            }
            if (CoapEndpoint.this.started) {
                CoapEndpoint.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        InboxImpl.this.receiveMessage(raw);
                    }
                });
            }
        }

        private void receiveMessage(RawData raw) {
            EndpointContext context = raw.getEndpointContext();
            Message msg = null;
            MessageFormatException ex = null;
            try {
                msg = CoapEndpoint.this.parser.parseMessage(raw);
                if (CoAP.isRequest(msg.getRawCode())) {
                    this.receiveRequest((Request)msg);
                    return;
                }
                if (CoAP.isResponse(msg.getRawCode())) {
                    if (raw.isMulticast()) {
                        LOGGER.debug("{}multicast-receiver silently ignoring responses from {}", (Object)CoapEndpoint.this.tag, (Object)raw.getEndpointContext());
                    } else {
                        this.receiveResponse((Response)msg);
                    }
                    return;
                }
                if (CoAP.isEmptyMessage(msg.getRawCode())) {
                    if (raw.isMulticast()) {
                        LOGGER.debug("{}multicast-receiver silently ignoring empty messages from {}", (Object)CoapEndpoint.this.tag, (Object)raw.getEndpointContext());
                    } else {
                        this.receiveEmptyMessage((EmptyMessage)msg);
                    }
                    return;
                }
                if (raw.isMulticast()) {
                    LOGGER.debug("{}multicast-receiver silently ignoring non-CoAP message from {}", (Object)CoapEndpoint.this.tag, (Object)raw.getEndpointContext());
                } else {
                    LOGGER.debug("{}silently ignoring non-CoAP message from {}", (Object)CoapEndpoint.this.tag, (Object)context);
                }
            }
            catch (CoAPMessageFormatException e) {
                ex = e;
                if (e.isConfirmable() && e.hasMid() && !raw.isMulticast()) {
                    if (CoAP.isRequest(e.getCode()) && e.getToken() != null && e.getErrorCode() != null) {
                        this.responseToMalformedRequest(context, e);
                        LOGGER.debug("{}respond malformed request from [{}], reason: {}", CoapEndpoint.this.tag, context, e.getMessage());
                    } else {
                        this.reject(raw, e);
                        LOGGER.debug("{}rejected malformed message from [{}], reason: {}", CoapEndpoint.this.tag, context, e.getMessage());
                    }
                } else {
                    LOGGER.debug("{}discarding malformed message from [{}]: {}", CoapEndpoint.this.tag, context, e.getMessage());
                }
            }
            catch (MessageFormatException e) {
                ex = e;
                LOGGER.debug("{}discarding malformed message from [{}]: {}", CoapEndpoint.this.tag, context, e.getMessage());
            }
            CoapEndpoint.this.notifyReceiveMalformedMessage(raw);
            if (LOGGER_BAN.isInfoEnabled()) {
                String address = context.getPeerAddress().getAddress().getHostAddress();
                String protocol = CoapEndpoint.this.connector.getProtocol();
                StringBuilder message = new StringBuilder();
                if (ex != null) {
                    char last;
                    message.append(ex.getMessage().trim());
                    int len = message.length();
                    if (len > 0 && (last = message.charAt(len - 1)) != '.' && last != '!' && last != ';' && last != '#') {
                        if (last == ':') {
                            message.setLength(len - 1);
                        }
                        message.append(";");
                    }
                    message.append(" ");
                }
                message.append(StringUtil.byteArray2HexString(raw.getBytes(), '\u0000', 8));
                LOGGER_BAN.info("{}{} {} Ban: {}", CoapEndpoint.this.tag, message, protocol, address);
            }
        }

        private void responseToMalformedRequest(EndpointContext destination, CoAPMessageFormatException cause) {
            Response response = new Response(cause.getErrorCode(), true);
            response.setDestinationContext(destination);
            response.setToken(cause.getToken());
            response.setMID(cause.getMid());
            response.setType(CoAP.Type.ACK);
            response.setPayload(cause.getMessage());
            CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.interceptors, response);
            response.setReadyToSend();
            if (!CoapEndpoint.this.started) {
                response.cancel();
            }
            RawData data = CoapEndpoint.this.serializer.serializeResponse(response, new SendingCallback<Response>(response){

                @Override
                protected void notifyPostProcess(Response response) {
                    CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.postProcessInterceptors, response);
                }
            });
            CoapEndpoint.this.connector.send(data);
        }

        private void reject(RawData raw, CoAPMessageFormatException cause) {
            EmptyMessage rst = new EmptyMessage(CoAP.Type.RST);
            rst.setMID(cause.getMid());
            rst.setDestinationContext(raw.getEndpointContext());
            CoapEndpoint.this.coapstack.sendEmptyMessage(null, rst);
        }

        private void receiveRequest(Request request) {
            request.setScheme(CoapEndpoint.this.scheme);
            if (!CoapEndpoint.this.started) {
                LOGGER.debug("{}not running, drop request {}", (Object)CoapEndpoint.this.tag, (Object)request);
                return;
            }
            CoapEndpoint.this.notifyReceive((List<MessageInterceptor>)CoapEndpoint.this.interceptors, request);
            if (!request.isCanceled()) {
                CoapEndpoint.this.matcher.receiveRequest(request, CoapEndpoint.this.endpointStackReceiver);
            }
        }

        private void receiveResponse(Response response) {
            CoapEndpoint.this.notifyReceive((List<MessageInterceptor>)CoapEndpoint.this.interceptors, response);
            if (!response.isCanceled()) {
                CoapEndpoint.this.matcher.receiveResponse(response, CoapEndpoint.this.endpointStackReceiver);
            }
        }

        private void receiveEmptyMessage(EmptyMessage message) {
            CoapEndpoint.this.notifyReceive((List<MessageInterceptor>)CoapEndpoint.this.interceptors, message);
            if (!message.isCanceled()) {
                if ((message.getType() == CoAP.Type.CON || message.getType() == CoAP.Type.NON) && message.hasMID()) {
                    LOGGER.debug("{}responding to ping from {}", (Object)CoapEndpoint.this.tag, (Object)message.getSourceContext());
                    CoapEndpoint.this.endpointStackReceiver.reject(message);
                } else if (CoapEndpoint.this.isMulticastMid(message.getMID())) {
                    LOGGER.debug("{} silently ignoring empty messages for multicast request {}", (Object)CoapEndpoint.this.tag, (Object)message.getSourceContext());
                    message.setCanceled(true);
                    CoapEndpoint.this.endpointStackReceiver.receiveEmptyMessage(null, message);
                } else {
                    CoapEndpoint.this.matcher.receiveEmptyMessage(message, CoapEndpoint.this.endpointStackReceiver);
                }
            }
        }
    }

    public class OutboxImpl
    implements Outbox {
        @Override
        public void sendRequest(Exchange exchange, Request request) {
            this.assertMessageHasDestinationAddress(request);
            exchange.setCurrentRequest(request);
            CoapEndpoint.this.matcher.sendRequest(exchange);
            CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.interceptors, request);
            request.setReadyToSend();
            if (!CoapEndpoint.this.started) {
                request.cancel();
            }
            if (request.isCanceled() || request.getSendError() != null) {
                exchange.executeComplete();
            } else {
                if (exchange.getFailedTransmissionCount() == 0) {
                    exchange.startTransmissionRtt();
                }
                RawData message = CoapEndpoint.this.serializer.serializeRequest(request, new ExchangeCallback<Request>(exchange, request){

                    @Override
                    protected void notifyPostProcess(Request request) {
                        CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.postProcessInterceptors, request);
                    }
                });
                CoapEndpoint.this.connector.send(message);
            }
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            this.assertMessageHasDestinationAddress(response);
            exchange.setCurrentResponse(response);
            CoapEndpoint.this.matcher.sendResponse(exchange);
            CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.interceptors, response);
            response.setReadyToSend();
            if (!CoapEndpoint.this.started) {
                response.cancel();
            }
            if (response.isCanceled() || response.getSendError() != null) {
                exchange.executeComplete();
            } else {
                RawData data = CoapEndpoint.this.serializer.serializeResponse(response, new ExchangeCallback<Response>(exchange, response){

                    @Override
                    protected void notifyPostProcess(Response response) {
                        CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.postProcessInterceptors, response);
                        if (CoapEndpoint.this.useRequestOffloading) {
                            this.exchange.getCurrentRequest().offload(Message.OffloadMode.FULL);
                            response.offload(Message.OffloadMode.PAYLOAD);
                        }
                    }
                });
                if (response.isConfirmable() && exchange.getFailedTransmissionCount() == 0) {
                    exchange.startTransmissionRtt();
                }
                CoapEndpoint.this.connector.send(data);
            }
        }

        @Override
        public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
            this.assertMessageHasDestinationAddress(message);
            CoapEndpoint.this.matcher.sendEmptyMessage(exchange, message);
            CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.interceptors, message);
            message.setReadyToSend();
            if (!CoapEndpoint.this.started) {
                message.cancel();
            }
            if (message.isCanceled() || message.getSendError() != null) {
                if (null != exchange) {
                    exchange.executeComplete();
                }
            } else if (exchange != null) {
                CoapEndpoint.this.connector.send(CoapEndpoint.this.serializer.serializeEmptyMessage(message, new ExchangeCallback<EmptyMessage>(exchange, message){

                    @Override
                    protected void notifyPostProcess(EmptyMessage message) {
                        CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.postProcessInterceptors, message);
                    }
                }));
            } else {
                CoapEndpoint.this.connector.send(CoapEndpoint.this.serializer.serializeEmptyMessage(message, new SendingCallback<EmptyMessage>(message){

                    @Override
                    protected void notifyPostProcess(EmptyMessage message) {
                        CoapEndpoint.this.notifySend((List<MessageInterceptor>)CoapEndpoint.this.postProcessInterceptors, message);
                    }
                }));
            }
        }

        private void assertMessageHasDestinationAddress(Message message) {
            if (message.getDestinationContext() == null) {
                throw new IllegalArgumentException("Message has no endpoint context");
            }
        }
    }

    private class NotificationDispatcher
    implements BiConsumer<Request, Response> {
        private NotificationDispatcher() {
        }

        @Override
        public void accept(Request request, Response response) {
            for (BiConsumer notificationListener : CoapEndpoint.this.notificationListeners) {
                notificationListener.accept(request, response);
            }
        }
    }

    public static class Builder {
        private Configuration config = null;
        private InetSocketAddress bindAddress = null;
        private Connector connector = null;
        private ObservationStore observationStore = null;
        private MessageExchangeStore exchangeStore = null;
        private EndpointContextMatcher endpointContextMatcher = null;
        private TokenGenerator tokenGenerator;
        private CoapStackFactory coapStackFactory;
        private DataSerializer serializer;
        private DataParser parser;
        private OptionRegistry optionRegistry;
        private String tag;
        private Object customStackArgument;

        public Builder setConfiguration(Configuration config) {
            this.config = config;
            return this;
        }

        public Builder setPort(int port) {
            if (this.bindAddress != null || this.connector != null) {
                throw new IllegalStateException("bind address already defined!");
            }
            this.bindAddress = new InetSocketAddress(port);
            return this;
        }

        public Builder setInetSocketAddress(InetSocketAddress address) {
            if (this.bindAddress != null || this.connector != null) {
                throw new IllegalStateException("bind address already defined!");
            }
            this.bindAddress = address;
            return this;
        }

        public Builder setConnector(Connector connector) {
            if (this.bindAddress != null || this.connector != null) {
                throw new IllegalStateException("bind address already defined!");
            }
            if (connector instanceof UdpMulticastConnector && ((UdpMulticastConnector)connector).isMutlicastReceiver()) {
                throw new IllegalStateException("connector must not be a multicast receiver!");
            }
            this.connector = connector;
            return this;
        }

        public Builder setObservationStore(ObservationStore store) {
            this.observationStore = store;
            return this;
        }

        public Builder setMessageExchangeStore(MessageExchangeStore exchangeStore) {
            this.exchangeStore = exchangeStore;
            return this;
        }

        public Builder setEndpointContextMatcher(EndpointContextMatcher endpointContextMatcher) {
            this.endpointContextMatcher = endpointContextMatcher;
            return this;
        }

        public Builder setTokenGenerator(TokenGenerator tokenGenerator) {
            this.tokenGenerator = tokenGenerator;
            return this;
        }

        public Builder setCoapStackFactory(CoapStackFactory coapStackFactory) {
            this.coapStackFactory = coapStackFactory;
            return this;
        }

        public Builder setDataSerializerAndParser(DataSerializer serializer, DataParser parser) {
            this.serializer = serializer;
            this.parser = parser;
            return this;
        }

        public Builder setOptionRegistry(OptionRegistry optionRegistry) {
            this.optionRegistry = optionRegistry;
            return this;
        }

        public Builder setLoggingTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setCustomCoapStackArgument(Object customStackArgument) {
            this.customStackArgument = customStackArgument;
            return this;
        }

        public CoapEndpoint build() {
            if (this.config == null) {
                this.config = Configuration.getStandard();
            }
            if (this.connector == null) {
                if (this.bindAddress == null) {
                    this.bindAddress = new InetSocketAddress(0);
                }
                this.connector = new UDPConnector(this.bindAddress, this.config);
            }
            if (this.tokenGenerator == null) {
                this.tokenGenerator = new RandomTokenGenerator(this.config);
            }
            if (this.observationStore == null) {
                this.observationStore = new InMemoryObservationStore(this.config);
            }
            if (this.endpointContextMatcher == null) {
                this.endpointContextMatcher = EndpointContextMatcherFactory.create(this.connector, this.config);
            }
            if (this.tag == null) {
                this.tag = CoAP.getSchemeForProtocol(this.connector.getProtocol());
            }
            this.tag = StringUtil.normalizeLoggingTag(this.tag);
            InMemoryMessageExchangeStore store = null;
            if (this.exchangeStore == null) {
                store = new InMemoryMessageExchangeStore(this.tag, this.config, this.tokenGenerator);
                this.exchangeStore = store;
            }
            if (this.coapStackFactory == null) {
                this.coapStackFactory = CoapEndpoint.getDefaultCoapStackFactory();
            }
            if (this.parser == null) {
                if (CoAP.isTcpProtocol(this.connector.getProtocol())) {
                    this.parser = new TcpDataParser(this.optionRegistry);
                    if (store != null) {
                        store.setDeduplicator(new NoDeduplicator());
                    }
                } else {
                    boolean strictEmptyMessageFormat = this.config.get(CoapConfig.STRICT_EMPTY_MESSAGE_FORMAT);
                    this.parser = new UdpDataParser(strictEmptyMessageFormat, this.optionRegistry);
                }
            }
            return new CoapEndpoint(this.connector, this.config, this.tokenGenerator, this.observationStore, this.exchangeStore, this.endpointContextMatcher, this.serializer, this.parser, this.tag, this.coapStackFactory, this.customStackArgument);
        }
    }

    private static abstract class ExchangeCallback<T extends Message>
    extends SendingCallback<T> {
        protected final Exchange exchange;

        public ExchangeCallback(Exchange exchange, T message) {
            super(message);
            if (null == exchange) {
                throw new NullPointerException("exchange must not be null");
            }
            this.exchange = exchange;
        }

        @Override
        protected void onContextEstablished(EndpointContext context, long nanoTimestamp) {
            this.exchange.setSendNanoTimestamp(nanoTimestamp == 0L ? -1L : nanoTimestamp);
            this.exchange.setEndpointContext(context);
        }
    }

    private static abstract class SendingCallback<T extends Message>
    implements MessageCallback {
        private final T message;

        public SendingCallback(T message) {
            if (null == message) {
                throw new NullPointerException("message must not be null");
            }
            this.message = message;
        }

        @Override
        public void onConnecting() {
            ((Message)this.message).onConnecting();
        }

        @Override
        public void onDtlsRetransmission(int flight) {
            ((Message)this.message).onDtlsRetransmission(flight);
        }

        @Override
        public final void onContextEstablished(EndpointContext context) {
            long now = ClockUtil.nanoRealtime();
            ((Message)this.message).setNanoTimestamp(now);
            this.onContextEstablished(context, now);
        }

        @Override
        public void onSent() {
            if (((Message)this.message).isSent()) {
                ((Message)this.message).setDuplicate(true);
            }
            ((Message)this.message).setSent(true);
            this.notifyPostProcess(this.message);
        }

        @Override
        public void onError(Throwable error) {
            ((Message)this.message).setSendError(error);
            this.notifyPostProcess(this.message);
        }

        protected abstract void notifyPostProcess(T var1);

        protected void onContextEstablished(EndpointContext context, long nanoTimestamp) {
        }
    }
}

