/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.Matcher;
import org.eclipse.californium.core.network.MessageExchangeStore;
import org.eclipse.californium.core.network.TokenGenerator;
import org.eclipse.californium.core.observe.Observation;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointIdentityResolver;
import org.eclipse.californium.elements.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMatcher
implements Matcher {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMatcher.class);
    protected final Configuration config;
    protected final ObservationStore observationStore;
    protected final MessageExchangeStore exchangeStore;
    protected final TokenGenerator tokenGenerator;
    protected final Executor executor;
    protected boolean running = false;
    private final BiConsumer<Request, Response> notificationListener;
    private final EndpointIdentityResolver identityResolver;

    public BaseMatcher(Configuration config, BiConsumer<Request, Response> notificationListener, TokenGenerator tokenGenerator, ObservationStore observationStore, MessageExchangeStore exchangeStore, EndpointIdentityResolver identityResolver, Executor executor) {
        if (config == null) {
            throw new NullPointerException("Config must not be null");
        }
        if (notificationListener == null) {
            throw new NullPointerException("NotificationListener must not be null");
        }
        if (tokenGenerator == null) {
            throw new NullPointerException("TokenGenerator must not be null");
        }
        if (exchangeStore == null) {
            throw new NullPointerException("MessageExchangeStore must not be null");
        }
        if (observationStore == null) {
            throw new NullPointerException("ObservationStore must not be null");
        }
        if (identityResolver == null) {
            throw new NullPointerException("EndpointIdentityResolver must not be null");
        }
        if (executor == null) {
            throw new NullPointerException("Executor must not be null");
        }
        this.config = config;
        this.notificationListener = notificationListener;
        this.exchangeStore = exchangeStore;
        this.observationStore = observationStore;
        this.tokenGenerator = tokenGenerator;
        this.identityResolver = identityResolver;
        this.executor = executor;
    }

    @Override
    public synchronized void start() {
        if (!this.running) {
            this.exchangeStore.start();
            this.observationStore.start();
            this.running = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.running) {
            this.exchangeStore.stop();
            this.observationStore.stop();
            this.clear();
            this.running = false;
        }
    }

    @Override
    public void clear() {
    }

    protected final void registerObserve(Request request) {
        if (!request.getOptions().hasBlock2() || request.getOptions().getBlock2().getNum() == 0) {
            LOG.debug("registering observe request {}", (Object)request);
            Token token = request.getToken();
            if (token == null) {
                do {
                    token = this.tokenGenerator.createToken(TokenGenerator.Scope.LONG_TERM);
                    request.setToken(token);
                } while (this.observationStore.putIfAbsent(token, new Observation(request, null)) != null);
            } else {
                this.observationStore.put(token, new Observation(request, null));
            }
            request.addMessageObserver(new ObservationObserverAdapter(token){

                @Override
                public void onCancel() {
                    this.remove();
                }

                @Override
                protected void failed() {
                    this.remove();
                }

                @Override
                public void onContextEstablished(EndpointContext endpointContext) {
                    BaseMatcher.this.observationStore.setContext(this.token, endpointContext);
                }
            });
        }
    }

    protected final Exchange matchNotifyResponse(Response response) {
        Token token;
        Observation obs;
        Exchange exchange = null;
        if ((!response.isSuccess() || response.getOptions().hasObserve()) && (obs = this.observationStore.get(token = response.getToken())) != null) {
            final Request request = obs.getRequest();
            Object identity = this.identityResolver.getEndpointIdentity(response.getSourceContext());
            exchange = new Exchange(request, identity, Exchange.Origin.LOCAL, this.executor, obs.getContext(), true);
            LOG.debug("re-created exchange from original observe request: {}", (Object)request);
            request.addMessageObserver(new ObservationObserverAdapter(token){

                @Override
                public void onResponse(Response response) {
                    try {
                        BaseMatcher.this.notificationListener.accept(request, response);
                    }
                    finally {
                        if (!response.isNotification()) {
                            LOG.debug("observation with token {} removed, removing from observation store", (Object)this.token);
                            this.remove();
                        }
                    }
                }
            });
        }
        return exchange;
    }

    @Override
    public void cancelObserve(Token token) {
        boolean found = false;
        for (Exchange exchange : this.exchangeStore.findByToken(token)) {
            Request request = exchange.getRequest();
            if (!request.isObserve()) continue;
            request.cancel();
            if (!exchange.isNotification()) {
                found = true;
            }
            exchange.executeComplete();
        }
        if (!found) {
            this.observationStore.remove(token);
        }
    }

    private class ObservationObserverAdapter
    extends MessageObserverAdapter {
        protected final AtomicBoolean removed;
        protected final Token token;

        public ObservationObserverAdapter(Token token) {
            super(true);
            this.removed = new AtomicBoolean();
            this.token = token;
        }

        @Override
        public void onResponse(Response response) {
            Observation observation = BaseMatcher.this.observationStore.get(this.token);
            if (observation != null && (response.isError() || !response.isNotification())) {
                LOG.debug("observation with token {} not established, removing from observation store", (Object)this.token);
                this.remove();
            }
        }

        protected void remove() {
            if (this.removed.compareAndSet(false, true)) {
                BaseMatcher.this.observationStore.remove(this.token);
            }
        }
    }
}

