/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.OpaqueOption;
import org.eclipse.californium.elements.util.DatagramReader;

public class StringOption
extends OpaqueOption {
    private final String value;

    public StringOption(Definition definition, byte[] value) {
        super(definition, value);
        this.value = Definition.getStringValue(value);
    }

    public StringOption(Definition definition, String value) {
        super(definition, Definition.setStringValue(value));
        this.value = value;
    }

    public String getStringValue() {
        return this.value;
    }

    @Override
    public String toValueString() {
        return "\"" + this.getStringValue() + "\"";
    }

    public static class Definition
    extends OpaqueOption.Definition {
        public Definition(int number, String name) {
            this(number, name, true, null);
        }

        public Definition(int number, String name, boolean singleValue) {
            this(number, name, singleValue, null);
        }

        public Definition(int number, String name, boolean singleValue, int ... lengths) {
            super(number, name, singleValue, lengths);
        }

        @Override
        public OptionNumberRegistry.OptionFormat getFormat() {
            return OptionNumberRegistry.OptionFormat.STRING;
        }

        @Override
        public StringOption create(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Option " + this.getName() + " reader must not be null.");
            }
            return new StringOption(this, reader.readBytes(length));
        }

        @Override
        public StringOption create(byte[] value) {
            if (value == null) {
                throw new NullPointerException("Option " + this.getName() + " value must not be null.");
            }
            return new StringOption(this, value);
        }

        public StringOption create(String value) {
            if (value == null) {
                throw new NullPointerException("Option " + this.getName() + " value must not be null.");
            }
            return new StringOption(this, value);
        }

        public static String getStringValue(byte[] value) {
            return value == null ? null : new String(value, CoAP.UTF8_CHARSET);
        }

        public static byte[] setStringValue(String value) {
            return value == null ? null : value.getBytes(CoAP.UTF8_CHARSET);
        }
    }
}

