/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.OptionNumber;
import org.eclipse.californium.elements.util.DatagramWriter;

public abstract class Option
implements OptionNumber,
Comparable<OptionNumber> {
    private final OptionDefinition definition;

    protected Option(OptionDefinition definition) {
        if (definition == null) {
            throw new NullPointerException("Definition must not be null!");
        }
        this.definition = definition;
    }

    public OptionDefinition getDefinition() {
        return this.definition;
    }

    public abstract int getLength();

    @Override
    public int getNumber() {
        return this.definition.getNumber();
    }

    public abstract void writeTo(DatagramWriter var1);

    public byte[] encode() {
        DatagramWriter writer = new DatagramWriter(this.getLength());
        this.writeTo(writer);
        return writer.toByteArray();
    }

    public boolean isCritical() {
        return (this.getNumber() & 1) != 0;
    }

    public boolean isUnSafe() {
        return (this.getNumber() & 2) != 0;
    }

    public boolean isNoCacheKey() {
        return (this.getNumber() & 0x1E) == 28;
    }

    @Override
    public boolean isSingleValue() {
        return this.getDefinition().isSingleValue();
    }

    @Override
    public int compareTo(OptionNumber o) {
        return this.getNumber() - o.getNumber();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option op = (Option)o;
        return this.definition.equals(op.definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.definition.getName());
        sb.append(": ");
        sb.append(this.toValueString());
        return sb.toString();
    }

    public abstract String toValueString();
}

