/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyToken;
import org.eclipse.californium.core.observe.ObserveHealth;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.observe.ObservingEndpoint;
import org.eclipse.californium.core.server.resources.ObservableResource;
import org.eclipse.californium.elements.config.Configuration;

public class ObserveManager {
    private final ConcurrentHashMap<InetSocketAddress, ObservingEndpoint> endpoints = new ConcurrentHashMap();
    private final ConcurrentHashMap<KeyToken, ObserveRelation> relations = new ConcurrentHashMap();
    private final int maxObserves;
    private volatile ObserveHealth observeHealth;

    @Deprecated
    public ObserveManager() {
        this(null);
    }

    public ObserveManager(Configuration config) {
        int maxObserves = 0;
        if (config != null) {
            maxObserves = config.get(CoapConfig.MAX_SERVER_OBSERVES);
        }
        this.maxObserves = maxObserves;
    }

    public void setObserveHealth(ObserveHealth observeHealth) {
        this.observeHealth = observeHealth;
    }

    @Deprecated
    public ObservingEndpoint findObservingEndpoint(InetSocketAddress address) {
        ObservingEndpoint ep = this.endpoints.get(address);
        if (ep == null) {
            ep = this.createObservingEndpoint(address);
        }
        return ep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserveRelation(Exchange exchange, ObservableResource resource) {
        ObserveHealth observeHealth;
        ObserveRelation previous;
        ObserveRelation relation = new ObserveRelation(this, resource, exchange);
        ObserveManager observeManager = this;
        synchronized (observeManager) {
            previous = this.relations.get(relation.getKeyToken());
            if (previous != null || this.maxObserves == 0 || this.relations.size() < this.maxObserves) {
                this.relations.put(relation.getKeyToken(), relation);
                ObservingEndpoint endpoint = this.endpoints.get(relation.getSource());
                if (endpoint == null) {
                    endpoint = new ObservingEndpoint(relation.getSource());
                    relation.setEndpoint(endpoint);
                    this.endpoints.put(relation.getSource(), endpoint);
                } else {
                    relation.setEndpoint(endpoint);
                }
            }
        }
        if (previous != null) {
            previous.cancel();
        }
        if ((observeHealth = this.observeHealth) != null) {
            observeHealth.receivingObserveRequest();
            observeHealth.setObserveRelations(this.relations.size());
            observeHealth.setObserveEndpoints(this.endpoints.size());
        }
    }

    public void cancelObserveRelation(Exchange exchange) {
        ObserveHealth observeHealth;
        KeyToken keyToken = ObserveRelation.getKeyToken(exchange);
        ObserveRelation relation = this.relations.get(keyToken);
        if (relation != null) {
            relation.cancel();
        }
        if ((observeHealth = this.observeHealth) != null) {
            observeHealth.receivingCancelRequest();
        }
    }

    public void onRejectedNotification(ObserveRelation relation) {
        ObserveHealth observeHealth = this.observeHealth;
        if (observeHealth != null) {
            observeHealth.receivingReject();
        }
        relation.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserveRelation(ObserveRelation relation) {
        boolean change = this.relations.remove(relation.getKeyToken(), relation);
        ObservingEndpoint endpoint = relation.getEndpoint();
        if (endpoint != null) {
            endpoint.removeObserveRelation(relation);
            ObserveManager observeManager = this;
            synchronized (observeManager) {
                if (endpoint.isEmpty()) {
                    change = this.endpoints.remove(relation.getSource(), endpoint) || change;
                }
            }
        }
        ObserveHealth observeHealth = this.observeHealth;
        if (change && observeHealth != null) {
            observeHealth.setObserveRelations(this.relations.size());
            observeHealth.setObserveEndpoints(this.endpoints.size());
        }
    }

    public int getNumberOfEndpoints() {
        return this.endpoints.size();
    }

    public int getNumberOfObserverRelations() {
        return this.relations.size();
    }

    public boolean isFull() {
        return this.maxObserves > 0 && this.relations.size() >= this.maxObserves;
    }

    @Deprecated
    public ObservingEndpoint getObservingEndpoint(InetSocketAddress address) {
        return this.endpoints.get(address);
    }

    @Deprecated
    private ObservingEndpoint createObservingEndpoint(InetSocketAddress address) {
        ObservingEndpoint ep = new ObservingEndpoint(address);
        ObservingEndpoint previous = this.endpoints.putIfAbsent(address, ep);
        if (previous != null) {
            return previous;
        }
        return ep;
    }

    @Deprecated
    public ObserveRelation getRelation(InetSocketAddress address, Token token) {
        ObservingEndpoint remote = this.getObservingEndpoint(address);
        if (remote != null) {
            return remote.getObserveRelation(token);
        }
        return null;
    }
}

