/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.config;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.BasicListDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.TimeDefinition;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.DatagramFilter;
import org.eclipse.californium.scandium.DtlsDatagramFilter;
import org.eclipse.californium.scandium.DtlsHealth;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.MultiNodeConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SessionStore;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.SingleNodeConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.DefaultCipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.resumption.ConnectionStoreResumptionVerifier;
import org.eclipse.californium.scandium.dtls.resumption.ResumptionVerifier;
import org.eclipse.californium.scandium.dtls.x509.CertificateConfigurationHelper;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.ConfigurationHelperSetup;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ListUtils;

public final class DtlsConnectorConfig {
    private InetSocketAddress address;
    private NewAdvancedCertificateVerifier advancedCertificateVerifier;
    private Configuration configuration;
    private Boolean useReuseAddress;
    private ProtocolVersion protocolVersionForHelloVerifyRequests;
    private AdvancedPskStore advancedPskStore;
    private CertificateProvider certificateIdentityProvider;
    private CertificateConfigurationHelper certificateConfigurationHelper;
    private CipherSuiteSelector cipherSuiteSelector;
    private List<CipherSuite.CertificateKeyAlgorithm> supportedCertificatekeyAlgorithms;
    private List<CipherSuite> supportedCipherSuites;
    private List<SignatureAndHashAlgorithm> supportedSignatureAlgorithms;
    private List<XECDHECryptography.SupportedGroup> supportedGroups;
    private String loggingTag;
    private String serializationLabel;
    private ConnectionIdGenerator connectionIdGenerator;
    private ApplicationLevelInfoSupplier applicationLevelInfoSupplier;
    private ConnectionListener connectionListener;
    private SessionListener sessionListener;
    private DatagramFilter datagramFilter;
    private SessionStore sessionStore;
    private ResumptionVerifier resumptionVerifier;
    private DtlsHealth healthHandler;

    private DtlsConnectorConfig(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("Configuration must not be null!");
        }
        this.configuration = new Configuration(configuration);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public <T> T get(BasicDefinition<T> definition) {
        return this.configuration.get(definition);
    }

    public Long get(TimeDefinition definition, TimeUnit unit) {
        return this.configuration.get(definition, unit);
    }

    public int getTimeAsInt(TimeDefinition definition, TimeUnit unit) {
        return this.configuration.getTimeAsInt(definition, unit);
    }

    public ProtocolVersion getProtocolVersionForHelloVerifyRequests() {
        return this.protocolVersionForHelloVerifyRequests;
    }

    @Deprecated
    public Integer getRecordSizeLimit() {
        return this.configuration.get(DtlsConfig.DTLS_RECORD_SIZE_LIMIT);
    }

    @Deprecated
    public MaxFragmentLengthExtension.Length getMaxFragmentLength() {
        return this.configuration.get(DtlsConfig.DTLS_MAX_FRAGMENT_LENGTH);
    }

    @Deprecated
    public Integer getMaxFragmentedHandshakeMessageLength() {
        return this.configuration.get(DtlsConfig.DTLS_MAX_FRAGMENTED_HANDSHAKE_MESSAGE_LENGTH);
    }

    @Deprecated
    public Boolean useMultiRecordMessages() {
        return this.configuration.get(DtlsConfig.DTLS_USE_MULTI_RECORD_MESSAGES);
    }

    @Deprecated
    public Boolean useMultiHandshakeMessageRecords() {
        return this.configuration.get(DtlsConfig.DTLS_USE_MULTI_HANDSHAKE_MESSAGE_RECORDS);
    }

    @Deprecated
    public int getRetransmissionTimeout() {
        return this.configuration.getTimeAsInt(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public Integer getMaxRetransmissionTimeout() {
        return this.configuration.getTimeAsInt(DtlsConfig.DTLS_MAX_RETRANSMISSION_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public Float getRetransmissionRandomFactor() {
        return this.configuration.get(DtlsConfig.DTLS_RETRANSMISSION_INIT_RANDOM);
    }

    @Deprecated
    public Float getRetransmissionTimeoutScale() {
        return this.configuration.get(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT_SCALE);
    }

    @Deprecated
    public int getAdditionalTimeoutForEcc() {
        return this.configuration.getTimeAsInt(DtlsConfig.DTLS_ADDITIONAL_ECC_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Integer getBackOffRetransmission() {
        Integer backoff = this.configuration.get(DtlsConfig.DTLS_RETRANSMISSION_BACKOFF);
        if (backoff == null) {
            backoff = this.configuration.get(DtlsConfig.DTLS_MAX_RETRANSMISSIONS) / 2;
        }
        return backoff;
    }

    @Deprecated
    public Integer getMaxRetransmissions() {
        return this.configuration.get(DtlsConfig.DTLS_MAX_RETRANSMISSIONS);
    }

    @Deprecated
    public Integer getMaxDeferredProcessedOutgoingApplicationDataMessages() {
        return this.configuration.get(DtlsConfig.DTLS_MAX_DEFERRED_OUTBOUND_APPLICATION_MESSAGES);
    }

    @Deprecated
    public Integer getMaxDeferredProcessedIncomingRecordsSize() {
        return this.configuration.get(DtlsConfig.DTLS_MAX_DEFERRED_INBOUND_RECORDS_SIZE);
    }

    @Deprecated
    public Integer getMaxTransmissionUnit() {
        return this.configuration.get(DtlsConfig.DTLS_MAX_TRANSMISSION_UNIT);
    }

    @Deprecated
    public Integer getMaxTransmissionUnitLimit() {
        return this.configuration.get(DtlsConfig.DTLS_MAX_TRANSMISSION_UNIT_LIMIT);
    }

    @Deprecated
    public Boolean useEarlyStopRetransmission() {
        return this.configuration.get(DtlsConfig.DTLS_USE_EARLY_STOP_RETRANSMISSION);
    }

    public Boolean useReuseAddress() {
        return this.useReuseAddress;
    }

    @Deprecated
    public Boolean useServerNameIndication() {
        return this.configuration.get(DtlsConfig.DTLS_USE_SERVER_NAME_INDICATION);
    }

    @Deprecated
    public ExtendedMasterSecretMode getExtendedMasterSecretMode() {
        return this.configuration.get(DtlsConfig.DTLS_EXTENDED_MASTER_SECRET_MODE);
    }

    @Deprecated
    public Integer getVerifyPeersOnResumptionThreshold() {
        return this.configuration.get(DtlsConfig.DTLS_VERIFY_PEERS_ON_RESUMPTION_THRESHOLD);
    }

    @Deprecated
    public Boolean useHelloVerifyRequestForPsk() {
        return this.configuration.get(DtlsConfig.DTLS_USE_HELLO_VERIFY_REQUEST_FOR_PSK);
    }

    @Deprecated
    public Boolean useHelloVerifyRequest() {
        return this.configuration.get(DtlsConfig.DTLS_USE_HELLO_VERIFY_REQUEST);
    }

    public ConnectionIdGenerator getConnectionIdGenerator() {
        return this.connectionIdGenerator;
    }

    @Deprecated
    public Integer useDeprecatedCid() {
        return this.configuration.get(DtlsConfig.DTLS_USE_DEPRECATED_CID);
    }

    @Deprecated
    public Boolean supportsDeprecatedCid() {
        return this.configuration.get(DtlsConfig.DTLS_SUPPORT_DEPRECATED_CID);
    }

    @Deprecated
    public Integer getOutboundMessageBufferSize() {
        return this.configuration.get(DtlsConfig.DTLS_OUTBOUND_MESSAGE_BUFFER_SIZE);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public CertificateProvider getCertificateIdentityProvider() {
        return this.certificateIdentityProvider;
    }

    public CipherSuiteSelector getCipherSuiteSelector() {
        return this.cipherSuiteSelector;
    }

    @Deprecated
    public List<CipherSuite> getPreselectedCipherSuites() {
        return (List)((Object)this.configuration.get(DtlsConfig.DTLS_PRESELECTED_CIPHER_SUITES));
    }

    public List<CipherSuite.CertificateKeyAlgorithm> getSupportedCertificateKeyAlgorithm() {
        return this.supportedCertificatekeyAlgorithms;
    }

    public List<CipherSuite> getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    public List<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public List<XECDHECryptography.SupportedGroup> getSupportedGroups() {
        return this.supportedGroups;
    }

    public AdvancedPskStore getAdvancedPskStore() {
        return this.advancedPskStore;
    }

    public NewAdvancedCertificateVerifier getAdvancedCertificateVerifier() {
        return this.advancedCertificateVerifier;
    }

    public ApplicationLevelInfoSupplier getApplicationLevelInfoSupplier() {
        return this.applicationLevelInfoSupplier;
    }

    @Deprecated
    public CertificateAuthenticationMode getCertificateAuthenticationMode() {
        return this.configuration.get(DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE);
    }

    @Deprecated
    public Boolean verifyServerCertificatesSubject() {
        return this.configuration.get(DtlsConfig.DTLS_VERIFY_SERVER_CERTIFICATES_SUBJECT);
    }

    @Deprecated
    public DtlsConfig.DtlsRole getDtlsRole() {
        return this.configuration.get(DtlsConfig.DTLS_ROLE);
    }

    public String getDefaultHandshakeMode() {
        if (this.configuration.get(DtlsConfig.DTLS_ROLE) == DtlsConfig.DtlsRole.SERVER_ONLY) {
            return "none";
        }
        return this.configuration.get(DtlsConfig.DTLS_DEFAULT_HANDSHAKE_MODE);
    }

    public List<CertificateType> getIdentityCertificateTypes() {
        if (this.certificateIdentityProvider == null) {
            return null;
        }
        return this.certificateIdentityProvider.getSupportedCertificateTypes();
    }

    public List<CertificateType> getTrustCertificateTypes() {
        if (this.advancedCertificateVerifier == null) {
            return null;
        }
        return this.advancedCertificateVerifier.getSupportedCertificateTypes();
    }

    @Deprecated
    public Integer getMaxConnections() {
        return this.configuration.get(DtlsConfig.DTLS_MAX_CONNECTIONS);
    }

    @Deprecated
    public Long getStaleConnectionThresholdSeconds() {
        return this.configuration.get(DtlsConfig.DTLS_STALE_CONNECTION_THRESHOLD, TimeUnit.SECONDS);
    }

    @Deprecated
    public Integer getConnectorThreadCount() {
        return this.configuration.get(DtlsConfig.DTLS_CONNECTOR_THREAD_COUNT);
    }

    @Deprecated
    public Integer getReceiverThreadCount() {
        return this.configuration.get(DtlsConfig.DTLS_RECEIVER_THREAD_COUNT);
    }

    @Deprecated
    public Integer getSocketReceiveBufferSize() {
        return this.configuration.get(DtlsConfig.DTLS_RECEIVE_BUFFER_SIZE);
    }

    @Deprecated
    public Integer getSocketSendBufferSize() {
        return this.configuration.get(DtlsConfig.DTLS_SEND_BUFFER_SIZE);
    }

    public Long getAutoHandshakeTimeoutMillis() {
        Long timeout = this.configuration.get(DtlsConfig.DTLS_AUTO_HANDSHAKE_TIMEOUT, TimeUnit.MILLISECONDS);
        if (timeout != null && timeout <= 0L) {
            timeout = null;
        }
        return timeout;
    }

    @Deprecated
    public Boolean useServerSessionId() {
        return this.configuration.get(DtlsConfig.DTLS_SERVER_USE_SESSION_ID);
    }

    @Deprecated
    public Boolean useAntiReplayFilter() {
        return this.configuration.get(DtlsConfig.DTLS_USE_ANTI_REPLAY_FILTER);
    }

    @Deprecated
    public Integer useDisabledWindowFilter() {
        return this.configuration.get(DtlsConfig.DTLS_USE_DISABLED_WINDOW_FOR_ANTI_REPLAY_FILTER);
    }

    @Deprecated
    public Boolean useUpdateAddressUsingCidOnNewerRecords() {
        return this.configuration.get(DtlsConfig.DTLS_UPDATE_ADDRESS_USING_CID_ON_NEWER_RECORDS);
    }

    @Deprecated
    public Boolean useTruncatedCertificatePathForClientsCertificateMessage() {
        return this.configuration.get(DtlsConfig.DTLS_TRUNCATE_CLIENT_CERTIFICATE_PATH);
    }

    @Deprecated
    public Boolean useTruncatedCertificatePathForValidation() {
        return this.configuration.get(DtlsConfig.DTLS_TRUNCATE_CERTIFICATE_PATH_FOR_VALIDATION);
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public SessionListener getSessionListener() {
        return this.sessionListener;
    }

    public DatagramFilter getDatagramFilter() {
        return this.datagramFilter;
    }

    public SessionStore getSessionStore() {
        return this.sessionStore;
    }

    public ResumptionVerifier getResumptionVerifier() {
        return this.resumptionVerifier;
    }

    public String getLoggingTag() {
        return this.loggingTag;
    }

    public String getSerializationLabel() {
        return this.serializationLabel;
    }

    @Deprecated
    public int getHealthStatusIntervalMilliseconds() {
        return this.configuration.getTimeAsInt(SystemConfig.HEALTH_STATUS_INTERVAL, TimeUnit.MILLISECONDS);
    }

    public DtlsHealth getHealthHandler() {
        return this.healthHandler;
    }

    @Deprecated
    public Boolean useRecommendedCipherSuitesOnly() {
        return this.configuration.get(DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY);
    }

    @Deprecated
    public Boolean useRecommendedSupportedGroupsOnly() {
        return this.configuration.get(DtlsConfig.DTLS_RECOMMENDED_CURVES_ONLY);
    }

    @Deprecated
    public Boolean useRecommendedSignatureAndHashAlgorithmsOnly() {
        return this.configuration.get(DtlsConfig.DTLS_RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY);
    }

    protected Object clone() {
        DtlsConnectorConfig cloned = new DtlsConnectorConfig(this.configuration);
        cloned.address = this.address;
        cloned.advancedCertificateVerifier = this.advancedCertificateVerifier;
        cloned.useReuseAddress = this.useReuseAddress;
        cloned.protocolVersionForHelloVerifyRequests = this.protocolVersionForHelloVerifyRequests;
        cloned.advancedPskStore = this.advancedPskStore;
        cloned.certificateIdentityProvider = this.certificateIdentityProvider;
        cloned.certificateConfigurationHelper = this.certificateConfigurationHelper;
        cloned.cipherSuiteSelector = this.cipherSuiteSelector;
        cloned.supportedCertificatekeyAlgorithms = this.supportedCertificatekeyAlgorithms;
        cloned.supportedCipherSuites = this.supportedCipherSuites;
        cloned.supportedSignatureAlgorithms = this.supportedSignatureAlgorithms;
        cloned.supportedGroups = this.supportedGroups;
        cloned.loggingTag = this.loggingTag;
        cloned.serializationLabel = this.serializationLabel;
        cloned.connectionIdGenerator = this.connectionIdGenerator;
        cloned.applicationLevelInfoSupplier = this.applicationLevelInfoSupplier;
        cloned.connectionListener = this.connectionListener;
        cloned.sessionListener = this.sessionListener;
        cloned.datagramFilter = this.datagramFilter;
        cloned.sessionStore = this.sessionStore;
        cloned.resumptionVerifier = this.resumptionVerifier;
        cloned.healthHandler = this.healthHandler;
        return cloned;
    }

    public static Builder builder(Configuration configuration) {
        return new Builder(configuration);
    }

    public static Builder builder(DtlsConnectorConfig config) {
        return new Builder(config);
    }

    public static final class Builder {
        private DtlsConnectorConfig config;

        public Builder(Configuration configuration) {
            this.config = new DtlsConnectorConfig(configuration);
        }

        private Builder(DtlsConnectorConfig initialConfiguration) {
            this.config = (DtlsConnectorConfig)initialConfiguration.clone();
        }

        public <T> Builder set(BasicDefinition<T> definition, T value) {
            this.config.configuration.set(definition, value);
            return this;
        }

        public <T> Builder setAsList(BasicListDefinition<T> definition, T ... values) {
            this.config.configuration.setAsList(definition, values);
            return this;
        }

        public <T> Builder setAsListFromText(BasicListDefinition<T> definition, String ... values) {
            this.config.configuration.setAsListFromText(definition, values);
            return this;
        }

        public Builder set(TimeDefinition definition, Long value, TimeUnit unit) {
            this.config.configuration.set(definition, value, unit);
            return this;
        }

        public Builder set(TimeDefinition definition, int value, TimeUnit unit) {
            this.config.configuration.set(definition, value, unit);
            return this;
        }

        public Builder setAddress(InetSocketAddress address) {
            if (address.isUnresolved()) {
                throw new IllegalArgumentException("Bind address must not be unresolved");
            }
            this.config.address = address;
            return this;
        }

        public Builder setReuseAddress(boolean enable) {
            this.config.useReuseAddress = enable;
            return this;
        }

        public Builder setProtocolVersionForHelloVerifyRequests(ProtocolVersion protocolVersion) {
            this.config.protocolVersionForHelloVerifyRequests = protocolVersion;
            return this;
        }

        public Builder setHealthHandler(DtlsHealth healthHandler) {
            this.config.healthHandler = healthHandler;
            return this;
        }

        public Builder setCipherSuiteSelector(CipherSuiteSelector cipherSuiteSelector) {
            this.config.cipherSuiteSelector = cipherSuiteSelector;
            return this;
        }

        public Builder setAdvancedPskStore(AdvancedPskStore advancedPskStore) {
            this.config.advancedPskStore = advancedPskStore;
            return this;
        }

        public Builder setCertificateIdentityProvider(CertificateProvider certificateIdentityProvider) {
            this.config.certificateIdentityProvider = certificateIdentityProvider;
            return this;
        }

        public Builder setAdvancedCertificateVerifier(NewAdvancedCertificateVerifier verifier) {
            if (verifier == null) {
                throw new NullPointerException("CertificateVerifier must not be null");
            }
            this.config.advancedCertificateVerifier = verifier;
            return this;
        }

        public Builder setApplicationLevelInfoSupplier(ApplicationLevelInfoSupplier supplier) {
            if (supplier == null) {
                throw new NullPointerException("Supplier must not be null");
            }
            this.config.applicationLevelInfoSupplier = supplier;
            return this;
        }

        public Builder setConnectionIdGenerator(ConnectionIdGenerator connectionIdGenerator) {
            this.config.connectionIdGenerator = connectionIdGenerator;
            return this;
        }

        public Builder setLoggingTag(String tag) {
            this.config.loggingTag = tag;
            return this;
        }

        public Builder setSerializationLabel(String label) {
            this.config.serializationLabel = label;
            return this;
        }

        public Builder setConnectionListener(ConnectionListener connectionListener) {
            this.config.connectionListener = connectionListener;
            return this;
        }

        public Builder setSessionListener(SessionListener sessionListener) {
            this.config.sessionListener = sessionListener;
            return this;
        }

        public Builder setDatagramFilter(DatagramFilter datagramFilter) {
            this.config.datagramFilter = datagramFilter;
            return this;
        }

        public Builder setSessionStore(SessionStore sessionStore) {
            this.config.sessionStore = sessionStore;
            return this;
        }

        public Builder setResumptionVerifier(ResumptionVerifier resumptionVerifier) {
            this.config.resumptionVerifier = resumptionVerifier;
            return this;
        }

        public Builder setCertificateHelper(CertificateConfigurationHelper helper) {
            this.config.certificateConfigurationHelper = helper;
            return this;
        }

        public DtlsConnectorConfig getIncompleteConfig() {
            return this.config;
        }

        public DtlsConnectorConfig build() {
            Integer cidCodePoint;
            int maxRetransmissionTimeout;
            int maxRetransmission;
            this.config.loggingTag = StringUtil.normalizeLoggingTag(this.config.loggingTag);
            if (this.config.address == null) {
                this.config.address = new InetSocketAddress(0);
            }
            if (this.config.useReuseAddress == null) {
                this.config.useReuseAddress = Boolean.FALSE;
            }
            if ((maxRetransmission = this.config.get(DtlsConfig.DTLS_MAX_RETRANSMISSIONS).intValue()) < 1) {
                throw new IllegalStateException("Maximum retransmissions " + maxRetransmission + " must not be less than 1!");
            }
            Integer backoff = this.config.configuration.get(DtlsConfig.DTLS_RETRANSMISSION_BACKOFF);
            if (backoff != null && backoff >= maxRetransmission) {
                throw new IllegalStateException("Backoff for handshake retransmissions (" + backoff + ") must be less than the maximum retransmissions (" + maxRetransmission + ")!");
            }
            int retransmissionTimeout = this.config.getTimeAsInt(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, TimeUnit.MILLISECONDS);
            if (retransmissionTimeout > (maxRetransmissionTimeout = this.config.getTimeAsInt(DtlsConfig.DTLS_MAX_RETRANSMISSION_TIMEOUT, TimeUnit.MILLISECONDS))) {
                throw new IllegalStateException("Retransmission timeout " + retransmissionTimeout + " is more than the maximum " + maxRetransmissionTimeout + "!");
            }
            if (retransmissionTimeout <= 0) {
                throw new IllegalStateException("Retransmission timeout " + retransmissionTimeout + " must not be 0 or less!");
            }
            if (maxRetransmissionTimeout <= 0) {
                throw new IllegalStateException("Maximum retransmission timeout " + maxRetransmissionTimeout + " must not be 0 or less!");
            }
            if (this.config.get(DtlsConfig.DTLS_RETRANSMISSION_INIT_RANDOM).floatValue() < 1.0f) {
                throw new IllegalStateException("Retransmission timeout random factor " + this.config.get(DtlsConfig.DTLS_RETRANSMISSION_INIT_RANDOM) + " must not be less than 1.0!");
            }
            if (this.config.get(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT_SCALE).floatValue() < 1.0f) {
                throw new IllegalStateException("Retransmission timeout scale factor " + this.config.get(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT_SCALE) + " must not be less than 1.0!");
            }
            Integer mtu = this.config.get(DtlsConfig.DTLS_MAX_TRANSMISSION_UNIT);
            Integer mtuLimit = this.config.get(DtlsConfig.DTLS_MAX_TRANSMISSION_UNIT_LIMIT);
            if (mtu != null && mtuLimit != null && mtu > mtuLimit) {
                throw new IllegalStateException("MTU (" + mtu + " bytes) is larger than the limit (" + mtuLimit + " bytes)!");
            }
            Integer limit = this.config.get(DtlsConfig.DTLS_RECORD_SIZE_LIMIT);
            if (limit != null && limit > 16384) {
                throw new IllegalStateException("Record size limit " + limit + " must be less than " + 16384 + "!");
            }
            DtlsConfig.DtlsRole dtlsRole = this.config.get(DtlsConfig.DTLS_ROLE);
            if (dtlsRole == DtlsConfig.DtlsRole.SERVER_ONLY) {
                if (this.config.getCertificateAuthenticationMode() == CertificateAuthenticationMode.NONE && this.config.advancedCertificateVerifier != null) {
                    throw new IllegalStateException("configured certificate verifier is not used for client authentication mode NONE!");
                }
                if (this.config.getAutoHandshakeTimeoutMillis() != null) {
                    throw new IllegalStateException("DTLS_AUTO_HANDSHAKE_TIMEOUT must not be used with SERVER_ONLY!");
                }
            }
            if (this.config.get(DtlsConfig.DTLS_REMOVE_STALE_DOUBLE_PRINCIPALS).booleanValue() && !this.config.get(DtlsConfig.DTLS_READ_WRITE_LOCK_CONNECTION_STORE).booleanValue()) {
                throw new IllegalStateException("Removing stale double principals requires the read-write-lock connection store!!");
            }
            if (this.config.datagramFilter == null && this.config.get(DtlsConfig.DTLS_USE_DEFAULT_RECORD_FILTER).booleanValue()) {
                this.config.datagramFilter = new DtlsDatagramFilter();
            }
            if ((cidCodePoint = this.config.useDeprecatedCid()) != null) {
                HelloExtension.ExtensionType cidType = HelloExtension.ExtensionType.getExtensionTypeById(cidCodePoint);
                if (cidType == null) {
                    throw new IllegalStateException(cidCodePoint + " code point is not supported for extensions!");
                }
                if (cidType != HelloExtension.ExtensionType.CONNECTION_ID && cidType.getReplacementType() != HelloExtension.ExtensionType.CONNECTION_ID) {
                    throw new IllegalStateException(cidCodePoint + " (" + (Object)((Object)cidType) + ") is no supported CID extension code point!");
                }
            }
            this.config.supportedGroups = (List)((Object)this.config.configuration.get(DtlsConfig.DTLS_CURVES));
            if (this.config.supportedGroups == null) {
                this.config.supportedGroups = Collections.emptyList();
            }
            this.config.supportedSignatureAlgorithms = this.config.configuration.get(DtlsConfig.DTLS_SIGNATURE_AND_HASH_ALGORITHMS);
            if (this.config.supportedSignatureAlgorithms == null) {
                this.config.supportedSignatureAlgorithms = Collections.emptyList();
            }
            this.config.supportedCertificatekeyAlgorithms = (List)((Object)this.config.configuration.get(DtlsConfig.DTLS_CERTIFICATE_KEY_ALGORITHMS));
            if (this.config.supportedCertificatekeyAlgorithms == null) {
                this.config.supportedCertificatekeyAlgorithms = Collections.emptyList();
            }
            if (this.config.cipherSuiteSelector == null && dtlsRole != DtlsConfig.DtlsRole.CLIENT_ONLY) {
                this.config.cipherSuiteSelector = new DefaultCipherSuiteSelector();
            }
            if (this.config.resumptionVerifier == null && this.config.get(DtlsConfig.DTLS_SERVER_USE_SESSION_ID).booleanValue() && dtlsRole != DtlsConfig.DtlsRole.CLIENT_ONLY) {
                this.config.resumptionVerifier = new ConnectionStoreResumptionVerifier();
            }
            CertificateProvider provider = this.config.certificateIdentityProvider;
            NewAdvancedCertificateVerifier verifier = this.config.advancedCertificateVerifier;
            if (this.config.certificateConfigurationHelper == null) {
                CertificateConfigurationHelper helper = new CertificateConfigurationHelper();
                if (provider instanceof ConfigurationHelperSetup) {
                    ((ConfigurationHelperSetup)((Object)provider)).setupConfigurationHelper(helper);
                    this.config.certificateConfigurationHelper = helper;
                }
                if (verifier instanceof ConfigurationHelperSetup) {
                    ((ConfigurationHelperSetup)((Object)verifier)).setupConfigurationHelper(helper);
                    this.config.certificateConfigurationHelper = helper;
                }
            }
            this.config.supportedCipherSuites = (List)((Object)this.config.configuration.get(DtlsConfig.DTLS_CIPHER_SUITES));
            if (this.config.supportedCipherSuites == null || this.config.supportedCipherSuites.isEmpty()) {
                this.determineCipherSuitesFromConfig();
            }
            if (this.config.supportedCipherSuites.isEmpty()) {
                throw new IllegalStateException("Supported cipher suites must be set either explicitly or implicitly by means of setting the identity or PSK store");
            }
            if (this.config.useRecommendedCipherSuitesOnly().booleanValue()) {
                this.verifyRecommendedCipherSuitesOnly(this.config.supportedCipherSuites);
            }
            boolean certifacte = false;
            boolean ecc = false;
            boolean psk = false;
            for (CipherSuite suite : this.config.supportedCipherSuites) {
                if (suite.isPskBased()) {
                    this.verifyPskBasedCipherConfig(suite);
                    psk = true;
                } else if (suite.requiresServerCertificateMessage()) {
                    this.verifyCertificateBasedCipherConfig(suite);
                    certifacte = true;
                }
                if (!suite.isEccBased()) continue;
                ecc = true;
            }
            if (!psk && this.config.advancedPskStore != null) {
                throw new IllegalStateException("Advanced PSK store set, but no PSK cipher suite!");
            }
            if (certifacte) {
                if (this.config.supportedSignatureAlgorithms.isEmpty()) {
                    ArrayList<SignatureAndHashAlgorithm> algorithms = new ArrayList<SignatureAndHashAlgorithm>(SignatureAndHashAlgorithm.DEFAULT);
                    if (this.config.certificateConfigurationHelper != null) {
                        ListUtils.addIfAbsent(algorithms, this.config.certificateConfigurationHelper.getDefaultSignatureAndHashAlgorithms());
                    }
                    this.config.supportedSignatureAlgorithms = algorithms;
                }
                if (this.config.supportedCertificatekeyAlgorithms.isEmpty()) {
                    ArrayList keyAlgorithms = new ArrayList();
                    if (SignatureAndHashAlgorithm.isSupportedAlgorithm((List<SignatureAndHashAlgorithm>)this.config.supportedSignatureAlgorithms, CipherSuite.CertificateKeyAlgorithm.EC)) {
                        ListUtils.addIfAbsent(keyAlgorithms, CipherSuite.CertificateKeyAlgorithm.EC);
                    }
                    if (SignatureAndHashAlgorithm.isSupportedAlgorithm((List<SignatureAndHashAlgorithm>)this.config.supportedSignatureAlgorithms, CipherSuite.CertificateKeyAlgorithm.RSA)) {
                        ListUtils.addIfAbsent(keyAlgorithms, CipherSuite.CertificateKeyAlgorithm.RSA);
                    }
                    if (this.config.getConfiguration().get(DtlsConfig.DTLS_ROLE) == DtlsConfig.DtlsRole.CLIENT_ONLY) {
                        ListUtils.addIfAbsent(keyAlgorithms, CipherSuite.CertificateKeyAlgorithm.EC);
                    }
                    this.config.supportedCertificatekeyAlgorithms = keyAlgorithms;
                }
            } else {
                if (!this.config.supportedSignatureAlgorithms.isEmpty()) {
                    throw new IllegalStateException("supported signature and hash algorithms set, but no ecdhe based cipher suite!");
                }
                if (provider != null) {
                    throw new IllegalStateException("certificate identity set, but no certificate based cipher suite!");
                }
                if (this.config.advancedCertificateVerifier != null) {
                    throw new IllegalStateException("certificate trust set, but no certificate based cipher suite!");
                }
            }
            if (ecc) {
                if (this.config.supportedGroups.isEmpty()) {
                    ArrayList<XECDHECryptography.SupportedGroup> defaultGroups = new ArrayList<XECDHECryptography.SupportedGroup>(XECDHECryptography.SupportedGroup.getPreferredGroups());
                    if (this.config.certificateConfigurationHelper != null) {
                        ListUtils.addIfAbsent(defaultGroups, this.config.certificateConfigurationHelper.getDefaultSupportedGroups());
                    }
                    this.config.supportedGroups = defaultGroups;
                }
            } else if (!this.config.supportedGroups.isEmpty()) {
                throw new IllegalStateException("supported groups set, but no ecdhe based cipher suite!");
            }
            if (this.config.useRecommendedSupportedGroupsOnly().booleanValue()) {
                this.verifyRecommendedSupportedGroupsOnly(this.config.supportedGroups);
            }
            if (this.config.useRecommendedSignatureAndHashAlgorithmsOnly().booleanValue()) {
                this.verifyRecommendedSignatureAndHashAlgorithmsOnly(this.config.supportedSignatureAlgorithms);
            }
            if (this.config.certificateConfigurationHelper != null) {
                this.config.certificateConfigurationHelper.verifySignatureAndHashAlgorithmsConfiguration(this.config.supportedSignatureAlgorithms);
                this.config.certificateConfigurationHelper.verifySupportedGroupsConfiguration(this.config.supportedGroups);
                if (provider != null && provider.getSupportedCertificateTypes().contains((Object)CertificateType.X_509)) {
                    if (dtlsRole == DtlsConfig.DtlsRole.CLIENT_ONLY) {
                        if (!this.config.certificateConfigurationHelper.canBeUsedForAuthentication(true)) {
                            throw new IllegalStateException("certificate has no proper key usage for clients!");
                        }
                    } else if (dtlsRole == DtlsConfig.DtlsRole.SERVER_ONLY) {
                        if (!this.config.certificateConfigurationHelper.canBeUsedForAuthentication(false)) {
                            throw new IllegalStateException("certificate has no proper key usage for servers!");
                        }
                    } else {
                        if (!this.config.certificateConfigurationHelper.canBeUsedForAuthentication(true)) {
                            throw new IllegalStateException("certificate has no proper key usage as clients!");
                        }
                        if (!this.config.certificateConfigurationHelper.canBeUsedForAuthentication(false)) {
                            throw new IllegalStateException("certificate has no proper key usage as servers!");
                        }
                    }
                }
            }
            if (this.config.get(DtlsConfig.DTLS_USE_HELLO_VERIFY_REQUEST).booleanValue() && !this.config.get(DtlsConfig.DTLS_USE_HELLO_VERIFY_REQUEST_FOR_PSK).booleanValue() && !CipherSuite.containsPskBasedCipherSuite(this.config.supportedCipherSuites)) {
                throw new IllegalStateException("HELLO_VERIFY_REQUEST disabled for PSK, requires at least one PSK cipher suite!");
            }
            this.config.supportedCertificatekeyAlgorithms = ListUtils.init(this.config.supportedCertificatekeyAlgorithms);
            this.config.supportedCipherSuites = ListUtils.init(this.config.supportedCipherSuites);
            this.config.supportedGroups = ListUtils.init(this.config.supportedGroups);
            this.config.supportedSignatureAlgorithms = ListUtils.init(this.config.supportedSignatureAlgorithms);
            if (this.config.connectionIdGenerator == null) {
                Integer cidLength = this.config.configuration.get(DtlsConfig.DTLS_CONNECTION_ID_LENGTH);
                Integer cidNode = this.config.configuration.get(DtlsConfig.DTLS_CONNECTION_ID_NODE_ID);
                if (cidLength != null) {
                    if (cidNode != null) {
                        if (cidLength <= 4) {
                            throw new IllegalStateException(cidLength + " bytes are too small for multiple nodes CID! At least, 5 bytes are required.");
                        }
                        this.setConnectionIdGenerator(new MultiNodeConnectionIdGenerator(cidNode, cidLength));
                    } else {
                        this.setConnectionIdGenerator(new SingleNodeConnectionIdGenerator(cidLength));
                    }
                }
            }
            return this.config;
        }

        private void verifyPskBasedCipherConfig(CipherSuite suite) {
            if (this.config.advancedPskStore == null) {
                throw new IllegalStateException("PSK store must be set for configured " + suite.name());
            }
            if (!this.config.advancedPskStore.hasEcdhePskSupported() && suite.isEccBased()) {
                throw new IllegalStateException("PSK store doesn't support ECDHE! " + suite.name());
            }
        }

        private void verifyCertificateBasedCipherConfig(CipherSuite suite) {
            if (this.config.get(DtlsConfig.DTLS_ROLE) == DtlsConfig.DtlsRole.CLIENT_ONLY) {
                if (this.config.advancedCertificateVerifier == null) {
                    throw new IllegalStateException("certificate verifier must be set on client for configured " + suite.name());
                }
            } else {
                if (this.config.certificateIdentityProvider == null) {
                    throw new IllegalStateException("Identity must be set for configured " + suite.name());
                }
                List<CipherSuite.CertificateKeyAlgorithm> keyAlgorithms = this.config.certificateIdentityProvider.getSupportedCertificateKeyAlgorithms();
                if (!keyAlgorithms.contains((Object)suite.getCertificateKeyAlgorithm())) {
                    throw new IllegalStateException("One of the keys (" + keyAlgorithms + ") must be capable for configured " + suite.name());
                }
                if (this.config.getCertificateAuthenticationMode() != CertificateAuthenticationMode.NONE && this.config.advancedCertificateVerifier == null) {
                    throw new IllegalStateException("certificate verifier must be set for authentication using the configured " + suite.name());
                }
            }
        }

        private void verifyRecommendedCipherSuitesOnly(List<CipherSuite> suites) {
            StringBuilder message = new StringBuilder();
            for (CipherSuite cipherSuite : suites) {
                if (cipherSuite.isRecommended()) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(cipherSuite.name());
            }
            if (message.length() > 0) {
                throw new IllegalStateException("Not recommended cipher suites " + message + " used! (Requires to set DTLS_RECOMMENDED_CIPHER_SUITES_ONLY to false.)");
            }
        }

        private void verifyRecommendedSupportedGroupsOnly(List<XECDHECryptography.SupportedGroup> supportedGroups) {
            StringBuilder message = new StringBuilder();
            for (XECDHECryptography.SupportedGroup group : supportedGroups) {
                if (group.isRecommended()) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(group.name());
            }
            if (message.length() > 0) {
                throw new IllegalStateException("Not recommended supported groups (curves) " + message + " used! (Requires to set DTLS_RECOMMENDED_CURVES_ONLY to false.)");
            }
        }

        private void verifyRecommendedSignatureAndHashAlgorithmsOnly(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
            StringBuilder message = new StringBuilder();
            for (SignatureAndHashAlgorithm signature : signatureAndHashAlgorithms) {
                if (signature.isRecommended()) continue;
                if (message.length() > 0) {
                    message.append(", ");
                }
                message.append(signature.getJcaName());
            }
            if (message.length() > 0) {
                throw new IllegalStateException("Not recommended signature and hash algorithms " + message + " used! (Requires to set DTLS_RECOMMENDED_SIGNATURE_AND_HASH_ALGORITHMS_ONLY to false.)");
            }
        }

        private void determineCipherSuitesFromConfig() {
            List<CipherSuite> preselectedCipherSuites;
            List<CipherSuite> ciphers = new ArrayList<CipherSuite>();
            if (this.config.certificateIdentityProvider != null || this.config.advancedCertificateVerifier != null) {
                ArrayList<CipherSuite.CertificateKeyAlgorithm> keyAlgorithms = new ArrayList<CipherSuite.CertificateKeyAlgorithm>();
                if (this.config.getConfiguration().get(DtlsConfig.DTLS_ROLE) == DtlsConfig.DtlsRole.CLIENT_ONLY) {
                    if (this.config.supportedCertificatekeyAlgorithms.isEmpty()) {
                        ListUtils.addIfAbsent(keyAlgorithms, CipherSuite.CertificateKeyAlgorithm.EC);
                        if (this.config.certificateIdentityProvider != null) {
                            ListUtils.addIfAbsent(keyAlgorithms, this.config.certificateIdentityProvider.getSupportedCertificateKeyAlgorithms());
                        }
                    } else {
                        ListUtils.addIfAbsent(keyAlgorithms, this.config.supportedCertificatekeyAlgorithms);
                    }
                } else if (this.config.certificateIdentityProvider != null) {
                    ListUtils.addIfAbsent(keyAlgorithms, this.config.certificateIdentityProvider.getSupportedCertificateKeyAlgorithms());
                }
                if (!keyAlgorithms.isEmpty()) {
                    ciphers.addAll(CipherSuite.getCertificateCipherSuites((boolean)this.config.useRecommendedCipherSuitesOnly(), keyAlgorithms));
                }
            }
            if (this.config.advancedPskStore != null) {
                if (this.config.advancedPskStore.hasEcdhePskSupported()) {
                    ciphers.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm((boolean)this.config.useRecommendedCipherSuitesOnly(), CipherSuite.KeyExchangeAlgorithm.ECDHE_PSK));
                }
                ciphers.addAll(CipherSuite.getCipherSuitesByKeyExchangeAlgorithm((boolean)this.config.useRecommendedCipherSuitesOnly(), CipherSuite.KeyExchangeAlgorithm.PSK));
            }
            if ((preselectedCipherSuites = this.config.getPreselectedCipherSuites()) != null && !preselectedCipherSuites.isEmpty()) {
                ciphers = CipherSuite.preselectCipherSuites(ciphers, preselectedCipherSuites);
            }
            this.config.supportedCipherSuites = ciphers;
        }
    }
}

