/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.config.ValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentedDefinition<T>
extends Definition<T> {
    @Deprecated
    protected static final Logger LOGGER = LoggerFactory.getLogger(DocumentedDefinition.class);
    private final String documentation;
    private final T defaultValue;

    DocumentedDefinition(String key, String documentation, Class<T> valueType, T defaultValue) {
        super(key, valueType);
        this.documentation = documentation;
        this.defaultValue = defaultValue;
    }

    public String getTypeName() {
        return this.getValueType().getSimpleName();
    }

    public abstract String writeValue(T var1);

    public String getDocumentation() {
        return this.documentation;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T readValue(String value) {
        String errorMessage = null;
        if (value == null) {
            errorMessage = String.format("Key '%s': textual value must not be null!", this.getKey());
            throw new NullPointerException(errorMessage);
        }
        if (this.useTrim()) {
            value = value.trim();
        }
        if (value.isEmpty()) {
            errorMessage = String.format("Key '%s': textual value must not be empty!", this.getKey());
            throw new IllegalArgumentException(errorMessage);
        }
        try {
            T result = this.parseValue(value);
            return this.checkValue(result);
        }
        catch (NumberFormatException e) {
            errorMessage = String.format("Key '%s': value '%s' is no %s", this.getKey(), value, this.getTypeName());
        }
        catch (ValueException e) {
            errorMessage = String.format("Key '%s': %s", this.getKey(), e.getMessage());
        }
        catch (IllegalArgumentException e) {
            errorMessage = String.format("Key '%s': value '%s' %s", this.getKey(), value, e.getMessage());
        }
        throw new IllegalArgumentException(errorMessage);
    }

    public T checkValue(T value) throws ValueException {
        return value;
    }

    protected boolean isAssignableFrom(Object value) {
        return this.getValueType().isInstance(value);
    }

    protected Object checkRawValue(Object value) throws ValueException {
        return this.checkValue(value);
    }

    protected abstract T parseValue(String var1) throws ValueException;

    protected boolean useTrim() {
        return true;
    }

    protected String write(Object value) {
        return this.writeValue(value);
    }
}

