/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.oscore.ByteId;
import org.eclipse.californium.oscore.CoapOSException;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashMapCtxDB
implements OSCoreCtxDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(HashMapCtxDB.class);
    private HashMap<ByteId, HashMap<ByteId, OSCoreCtx>> contextMap;
    private HashMap<Token, OSCoreCtx> tokenMap = new HashMap();
    private HashMap<String, OSCoreCtx> uriMap;
    private ArrayList<Token> allTokens;

    public HashMapCtxDB() {
        this.contextMap = new HashMap();
        this.uriMap = new HashMap();
        this.allTokens = new ArrayList();
    }

    @Override
    public synchronized OSCoreCtx getContext(byte[] rid, byte[] IDContext) throws CoapOSException {
        if (rid == null) {
            LOGGER.error("KID is missing");
            throw new CoapOSException("KID is missing", CoAP.ResponseCode.UNAUTHORIZED);
        }
        HashMap<ByteId, OSCoreCtx> matchingRidMap = this.contextMap.get(new ByteId(rid));
        if (matchingRidMap == null) {
            return null;
        }
        if (IDContext == null) {
            if (matchingRidMap.size() > 1) {
                throw new CoapOSException("Security context not found (resend with ID Context)", CoAP.ResponseCode.UNAUTHORIZED);
            }
            Map.Entry<ByteId, OSCoreCtx> first = matchingRidMap.entrySet().iterator().next();
            return first.getValue();
        }
        return matchingRidMap.get(new ByteId(IDContext));
    }

    @Override
    public synchronized OSCoreCtx getContext(byte[] rid) {
        HashMap<ByteId, OSCoreCtx> matchingRidMap = this.contextMap.get(new ByteId(rid));
        if (matchingRidMap == null) {
            return null;
        }
        if (matchingRidMap.size() > 1) {
            throw new RuntimeException("Attempting to retrieve context with only non-unique RID.");
        }
        Map.Entry<ByteId, OSCoreCtx> first = matchingRidMap.entrySet().iterator().next();
        return first.getValue();
    }

    @Override
    public synchronized OSCoreCtx getContextByToken(Token token) {
        if (token != null) {
            return this.tokenMap.get(token);
        }
        LOGGER.error("Token is null");
        throw new NullPointerException("Token is null");
    }

    @Override
    public synchronized OSCoreCtx getContext(String uri) throws OSException {
        if (uri != null) {
            return this.uriMap.get(HashMapCtxDB.normalizeServerUri(uri));
        }
        LOGGER.error("String is null");
        throw new NullPointerException("String is null");
    }

    @Override
    public synchronized void addContext(Token token, OSCoreCtx ctx) {
        if (token != null) {
            if (!this.tokenExist(token)) {
                this.allTokens.add(token);
            }
            this.tokenMap.put(token, ctx);
        }
        this.addContext(ctx);
    }

    @Override
    public synchronized void addContext(String uri, OSCoreCtx ctx) throws OSException {
        if (uri != null) {
            String normalizedUri = HashMapCtxDB.normalizeServerUri(uri);
            this.uriMap.put(normalizedUri, ctx);
            ctx.setUri(normalizedUri);
        }
        this.addContext(ctx);
    }

    @Override
    public synchronized void addContext(OSCoreCtx ctx) {
        byte[] IDContext;
        HashMap<ByteId, OSCoreCtx> ridMap;
        ByteId rid;
        if (ctx != null) {
            rid = new ByteId(ctx.getRecipientId());
            ridMap = this.contextMap.get(rid);
            if (ridMap == null) {
                ridMap = new HashMap();
            }
            if ((IDContext = ctx.getIdContext()) == null) {
                IDContext = Bytes.EMPTY;
            }
        } else {
            LOGGER.error("Context is null");
            throw new NullPointerException("Context is null");
        }
        ridMap.put(new ByteId(IDContext), ctx);
        this.contextMap.put(rid, ridMap);
    }

    @Override
    public synchronized void removeContext(OSCoreCtx ctx) {
        if (ctx != null) {
            ByteId rid = new ByteId(ctx.getRecipientId());
            HashMap<ByteId, OSCoreCtx> ridMap = this.contextMap.get(rid);
            if (ridMap == null) {
                return;
            }
            byte[] IDContext = ctx.getIdContext();
            if (IDContext == null) {
                IDContext = Bytes.EMPTY;
            }
            ridMap.remove(new ByteId(IDContext));
            if (ridMap.isEmpty()) {
                this.contextMap.remove(rid);
            } else {
                this.contextMap.put(rid, ridMap);
            }
        } else {
            LOGGER.error("Context is null");
            throw new NullPointerException("Context is null");
        }
    }

    @Override
    public synchronized boolean tokenExist(Token token) {
        if (token != null) {
            return this.allTokens.contains(token);
        }
        LOGGER.error("Token is null");
        throw new NullPointerException("Token is null");
    }

    private static String normalizeServerUri(String uri) throws OSException {
        String normalized = null;
        int port = -1;
        try {
            URI serverUri = new URI(uri);
            port = serverUri.getPort();
            normalized = serverUri.getHost();
        }
        catch (URISyntaxException e) {
            try {
                String patternString = "(%.*)]";
                Pattern pattern = Pattern.compile(patternString);
                Matcher matcher = pattern.matcher(uri);
                String originalScope = null;
                if (matcher.find()) {
                    originalScope = matcher.group(1);
                }
                normalized = new URI(uri.replaceAll("[-._~]", "")).getHost();
                matcher = pattern.matcher(normalized);
                String newScope = null;
                if (matcher.find()) {
                    newScope = matcher.group(1);
                }
                if (newScope != null && originalScope != null) {
                    normalized = normalized.replace(newScope, originalScope);
                }
            }
            catch (URISyntaxException e2) {
                LOGGER.error("Error in the request URI: {} message: {}", (Object)uri, (Object)e.getMessage());
                throw new OSException(e.getMessage());
            }
        }
        InetAddress ipv6Addr = null;
        try {
            ipv6Addr = InetAddress.getByName(normalized);
        }
        catch (UnknownHostException e) {
            LOGGER.error("Error finding host of request URI: {} message: {}", (Object)uri, (Object)e.getMessage());
        }
        if (ipv6Addr instanceof Inet6Address) {
            normalized = "[" + ipv6Addr.getHostAddress() + "]";
        }
        if (port != -1 && port != 5683) {
            normalized = normalized + ":" + port;
        }
        return normalized;
    }

    @Override
    public synchronized void removeToken(Token token) {
        this.tokenMap.remove(token);
    }

    @Override
    public synchronized void purge() {
        this.contextMap.clear();
        this.tokenMap.clear();
        this.uriMap.clear();
        this.allTokens = new ArrayList();
    }
}

