/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.nio.charset.Charset;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.ServerKeyExchange;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class PSKServerKeyExchange
extends ServerKeyExchange {
    private static final int IDENTITY_HINT_LENGTH_BITS = 16;
    private static final Charset CHAR_SET = Charset.forName("UTF8");
    private byte[] hintEncoded;
    private String hint;

    public PSKServerKeyExchange(String hint) {
        this.hint = hint;
        this.hintEncoded = hint.getBytes(CHAR_SET);
    }

    public PSKServerKeyExchange(byte[] hintEncoded) {
        this.hintEncoded = hintEncoded;
        this.hint = new String(hintEncoded, CHAR_SET);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.hintEncoded.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\t\tPSK Identity Hint: " + this.hint + "\n");
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.hintEncoded.length, 16);
        writer.writeBytes(this.hintEncoded);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) {
        DatagramReader reader = new DatagramReader(byteArray);
        int length = reader.read(16);
        byte[] hintEncoded = reader.readBytes(length);
        return new PSKServerKeyExchange(hintEncoded);
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }
}

