/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.examples;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.logging.Level;
import org.eclipse.californium.core.CaliforniumLogger;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.CoAPEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.ScandiumLogger;
import org.eclipse.californium.scandium.dtls.pskstore.InMemoryPskStore;

public class SecureServer {
    public static final int DTLS_PORT;
    private static final String TRUST_STORE_PASSWORD = "rootPass";
    private static final String KEY_STORE_PASSWORD = "endPass";
    private static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    private static final String TRUST_STORE_LOCATION = "certs/trustStore.jks";

    public static void main(String[] args) {
        CoapServer server = new CoapServer();
        server.add(new CoapResource("secure"){

            @Override
            public void handleGET(CoapExchange exchange) {
                exchange.respond(CoAP.ResponseCode.CONTENT, "hello security");
            }
        });
        try {
            InMemoryPskStore pskStore = new InMemoryPskStore();
            pskStore.setKey("password", "sesame".getBytes());
            KeyStore trustStore = KeyStore.getInstance("JKS");
            FileInputStream inTrust = new FileInputStream(TRUST_STORE_LOCATION);
            trustStore.load(inTrust, TRUST_STORE_PASSWORD.toCharArray());
            Certificate[] trustedCertificates = new Certificate[]{trustStore.getCertificate("root")};
            DTLSConnector connector = new DTLSConnector(new InetSocketAddress(DTLS_PORT), trustedCertificates);
            connector.getConfig().setPskStore(pskStore);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream in = new FileInputStream(KEY_STORE_LOCATION);
            keyStore.load(in, KEY_STORE_PASSWORD.toCharArray());
            connector.getConfig().setPrivateKey((PrivateKey)keyStore.getKey("server", KEY_STORE_PASSWORD.toCharArray()), keyStore.getCertificateChain("server"), true);
            server.addEndpoint(new CoAPEndpoint(connector, NetworkConfig.getStandard()));
            server.start();
        }
        catch (IOException | GeneralSecurityException e) {
            System.err.println("Could not load the keystore");
            e.printStackTrace();
        }
        for (Endpoint ep : server.getEndpoints()) {
            ep.addInterceptor(new MessageTracer());
        }
        System.out.println("Secure CoAP server powered by Scandium (Sc) is listening on port " + DTLS_PORT);
    }

    static {
        CaliforniumLogger.initialize();
        CaliforniumLogger.setLevel(Level.CONFIG);
        ScandiumLogger.initialize();
        ScandiumLogger.setLevel(Level.FINER);
        DTLS_PORT = NetworkConfig.getStandard().getInt("COAP_SECURE_PORT");
    }
}

