/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.util.DatagramReader;

public class ServerCertificateTypeExtension
extends CertificateTypeExtension {
    public ServerCertificateTypeExtension(boolean isClient) {
        super(HelloExtensions.ExtensionType.SERVER_CERT_TYPE, isClient);
    }

    public ServerCertificateTypeExtension(boolean isClient, List<CertificateTypeExtension.CertificateType> certificateTypes) {
        super(HelloExtensions.ExtensionType.SERVER_CERT_TYPE, isClient, certificateTypes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (CertificateTypeExtension.CertificateType type : this.certificateTypes) {
            sb.append("\t\t\t\tServer certificate type: " + type.toString() + "\n");
        }
        return sb.toString();
    }

    public static HelloExtension fromByteArray(byte[] byteArray) {
        DatagramReader reader = new DatagramReader(byteArray);
        ArrayList<CertificateTypeExtension.CertificateType> certificateTypes = new ArrayList<CertificateTypeExtension.CertificateType>();
        boolean isClientExtension = true;
        if (byteArray.length > 1) {
            int length = reader.read(8);
            for (int i = 0; i < length; ++i) {
                certificateTypes.add(CertificateTypeExtension.CertificateType.getTypeFromCode(reader.read(8)));
            }
        } else {
            certificateTypes.add(CertificateTypeExtension.CertificateType.getTypeFromCode(reader.read(8)));
            isClientExtension = false;
        }
        return new ServerCertificateTypeExtension(isClientExtension, certificateTypes);
    }
}

