/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.UnsupportedEncodingException;
import org.eclipse.californium.scandium.dtls.ClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class PSKClientKeyExchange
extends ClientKeyExchange {
    private static final int IDENTITY_LENGTH_BITS = 16;
    private static final String CHAR_SET = "UTF8";
    private byte[] identityEncoded;
    private String identity;

    public PSKClientKeyExchange(String identity) {
        this.identity = identity;
        try {
            this.identityEncoded = identity.getBytes(CHAR_SET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public PSKClientKeyExchange(byte[] identityEncoded) {
        this.identityEncoded = identityEncoded;
        try {
            this.identity = new String(identityEncoded, CHAR_SET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getMessageLength() {
        return 2 + this.identityEncoded.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(super.toString());
        sb.append("\t\tPSK Identity: " + this.identity + "\n");
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.identityEncoded.length, 16);
        writer.writeBytes(this.identityEncoded);
        return writer.toByteArray();
    }

    public static HandshakeMessage fromByteArray(byte[] byteArray) {
        DatagramReader reader = new DatagramReader(byteArray);
        int length = reader.read(16);
        byte[] identityEncoded = reader.readBytes(length);
        return new PSKClientKeyExchange(identityEncoded);
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }
}

