/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class HelloExtensions {
    private static final Logger LOGGER = Logger.getLogger(HelloExtensions.class.getCanonicalName());
    private static final int LENGTH_BITS = 16;
    private static final int EXTENSION_LENGTH_BITS = 16;
    private static final int TYPE_BITS = 16;
    private List<HelloExtension> extensions;

    public HelloExtensions() {
        this.extensions = new ArrayList<HelloExtension>();
    }

    public HelloExtensions(List<HelloExtension> extensions) {
        this.extensions = extensions;
    }

    public int getLength() {
        int length = 0;
        for (HelloExtension extension : this.extensions) {
            length += extension.getLength();
        }
        return length;
    }

    public void addExtension(HelloExtension extension) {
        this.extensions.add(extension);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\tExtensions Length: " + this.getLength() + "\n");
        for (HelloExtension ext : this.extensions) {
            sb.append(ext.toString());
        }
        return sb.toString();
    }

    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.getLength(), 16);
        for (HelloExtension extension : this.extensions) {
            writer.writeBytes(extension.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HelloExtensions fromByteArray(byte[] byteArray) throws HandshakeException {
        int extensionLength;
        DatagramReader reader = new DatagramReader(byteArray);
        ArrayList<HelloExtension> extensions = new ArrayList<HelloExtension>();
        for (int length = reader.read(16); length > 0; length -= extensionLength + 4) {
            ExtensionType type = ExtensionType.getExtensionTypeById(reader.read(16));
            extensionLength = reader.read(16);
            if (type == null) continue;
            HelloExtension helloExtension = HelloExtension.fromByteArray(reader.readBytes(extensionLength), type);
            extensions.add(helloExtension);
        }
        return new HelloExtensions(extensions);
    }

    public List<HelloExtension> getExtensions() {
        return this.extensions;
    }

    public static enum ExtensionType {
        SERVER_NAME(0, "server_name"),
        MAX_FRAGMENT_LENGTH(1, "max_fragment_length"),
        CLIENT_CERTIFICATE_URL(2, "client_certificate_url"),
        TRUSTED_CA_KEYS(3, "trusted_ca_keys"),
        TRUNCATED_HMAC(4, "truncated_hmac"),
        STATUS_REQUEST(5, "status_request"),
        USER_MAPPING(6, "user_mapping"),
        CLIENT_AUTHZ(7, "client_authz"),
        SERVER_AUTHZ(8, "server_authz"),
        CERT_TYPE(9, "cert_type"),
        ELLIPTIC_CURVES(10, "elliptic_curves"),
        EC_POINT_FORMATS(11, "ec_point_formats"),
        SRP(12, "srp"),
        SIGNATURE_ALGORITHMS(13, "signature_algorithms"),
        USE_SRTP(14, "use_srtp"),
        HEARTBEAT(15, "heartbeat"),
        APPLICATION_LAYER_PROTOCOL_NEGOTIATION(16, "application_layer_protocol_negotiation"),
        STATUS_REQUEST_V2(17, "status_request_v2"),
        SIGNED_CERTIFICATE_TIMESTAMP(18, "signed_certificate_timestamp"),
        CLIENT_CERT_TYPE(19, "client_certificate_type"),
        SERVER_CERT_TYPE(20, "server_certificate_type");

        private int id;
        private String name;

        private ExtensionType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public static ExtensionType getExtensionTypeById(int id) throws HandshakeException {
            switch (id) {
                case 0: {
                    return SERVER_NAME;
                }
                case 1: {
                    return MAX_FRAGMENT_LENGTH;
                }
                case 2: {
                    return CLIENT_CERTIFICATE_URL;
                }
                case 3: {
                    return TRUSTED_CA_KEYS;
                }
                case 4: {
                    return TRUNCATED_HMAC;
                }
                case 5: {
                    return STATUS_REQUEST;
                }
                case 6: {
                    return USER_MAPPING;
                }
                case 7: {
                    return CLIENT_AUTHZ;
                }
                case 8: {
                    return SERVER_AUTHZ;
                }
                case 9: {
                    return CERT_TYPE;
                }
                case 10: {
                    return ELLIPTIC_CURVES;
                }
                case 11: {
                    return EC_POINT_FORMATS;
                }
                case 12: {
                    return SRP;
                }
                case 13: {
                    return SIGNATURE_ALGORITHMS;
                }
                case 14: {
                    return USE_SRTP;
                }
                case 15: {
                    return HEARTBEAT;
                }
                case 16: {
                    return APPLICATION_LAYER_PROTOCOL_NEGOTIATION;
                }
                case 17: {
                    return STATUS_REQUEST_V2;
                }
                case 18: {
                    return SIGNED_CERTIFICATE_TIMESTAMP;
                }
                case 19: {
                    return CLIENT_CERT_TYPE;
                }
                case 20: {
                    return SERVER_CERT_TYPE;
                }
            }
            LOGGER.severe("Unknown extension type code: " + id);
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNSUPPORTED_EXTENSION);
            throw new HandshakeException("Unknown extension type code received: " + id, alert);
        }

        public String toString() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }
}

