/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.util.DatagramWriter;

public abstract class CertificateTypeExtension
extends HelloExtension {
    protected static final int LIST_FIELD_LENGTH_BITS = 8;
    protected static final int EXTENSION_TYPE_BITS = 8;
    private boolean isClientExtension;
    protected List<CertificateType> certificateTypes;

    public CertificateTypeExtension(HelloExtensions.ExtensionType type, boolean isClient) {
        super(type);
        this.isClientExtension = isClient;
        this.certificateTypes = new ArrayList<CertificateType>();
    }

    public CertificateTypeExtension(HelloExtensions.ExtensionType type, boolean isClient, List<CertificateType> certificateTypes) {
        super(type);
        this.isClientExtension = isClient;
        this.certificateTypes = certificateTypes;
    }

    public boolean isClientExtension() {
        return this.isClientExtension;
    }

    @Override
    public int getLength() {
        if (this.isClientExtension) {
            return 5 + this.certificateTypes.size();
        }
        return 5;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.writeBytes(super.toByteArray());
        if (this.isClientExtension) {
            int listLength = this.certificateTypes.size();
            writer.write(listLength + 1, 16);
            writer.write(listLength, 8);
            for (CertificateType type : this.certificateTypes) {
                writer.write(type.getCode(), 8);
            }
        } else {
            writer.write(1, 16);
            writer.write(this.certificateTypes.get(0).getCode(), 8);
        }
        return writer.toByteArray();
    }

    public void addCertificateType(CertificateType certificateType) {
        if (!this.isClientExtension && this.certificateTypes.size() > 0) {
            return;
        }
        this.certificateTypes.add(certificateType);
    }

    public List<CertificateType> getCertificateTypes() {
        return this.certificateTypes;
    }

    public static enum CertificateType {
        X_509(0),
        OPEN_PGP(1),
        RAW_PUBLIC_KEY(2);

        private int code;

        private CertificateType(int code) {
            this.code = code;
        }

        public static CertificateType getTypeFromCode(int code) {
            switch (code) {
                case 0: {
                    return X_509;
                }
                case 1: {
                    return OPEN_PGP;
                }
                case 2: {
                    return RAW_PUBLIC_KEY;
                }
            }
            return null;
        }

        int getCode() {
            return this.code;
        }
    }
}

