/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.DTLSMessage;
import org.eclipse.californium.scandium.util.DatagramReader;
import org.eclipse.californium.scandium.util.DatagramWriter;

public class AlertMessage
implements DTLSMessage {
    private static final int BITS = 8;
    private AlertLevel level;
    private AlertDescription description;

    public AlertMessage(AlertLevel level, AlertDescription description) {
        this.level = level;
        this.description = description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tAlert Protocol\n");
        sb.append("\tLevel: " + this.level.toString() + "\n");
        sb.append("\tDescription: " + this.description.toString() + " \n");
        return sb.toString();
    }

    @Override
    public byte[] toByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.level.getCode(), 8);
        writer.write(this.description.getCode(), 8);
        return writer.toByteArray();
    }

    public static DTLSMessage fromByteArray(byte[] byteArray) {
        DatagramReader reader = new DatagramReader(byteArray);
        int level = reader.read(8);
        int description = reader.read(8);
        return new AlertMessage(AlertLevel.getLevelByCode(level), AlertDescription.getDescriptionByCode(description));
    }

    public AlertLevel getLevel() {
        return this.level;
    }

    public AlertDescription getDescription() {
        return this.description;
    }

    public static enum AlertDescription {
        CLOSE_NOTIFY(0),
        UNEXPECTED_MESSAGE(10),
        BAD_RECORD_MAC(20),
        DECRYPTION_FAILED_RESERVED(21),
        RECORD_OVERFLOW(22),
        DECOMPRESSION_FAILURE(30),
        HANDSHAKE_FAILURE(40),
        NO_CERTIFICATE_RESERVED(41),
        BAD_CERTIFICATE(42),
        UNSUPPORTED_CERTIFICATE(43),
        CERTIFICATE_REVOKED(44),
        CERTIFICATE_EXPIRED(45),
        CERTIFICATE_UNKNOWN(46),
        ILLEGAL_PARAMETER(47),
        UNKNOWN_CA(48),
        ACCESS_DENIED(49),
        DECODE_ERROR(50),
        DECRYPT_ERROR(51),
        EXPORT_RESTRICTION_RESERVED(60),
        PROTOCOL_VERSION(70),
        INSUFFICIENT_SECURITY(71),
        INTERNAL_ERROR(80),
        USER_CANCELED(90),
        NO_RENEGOTIATION(100),
        UNSUPPORTED_EXTENSION(110);

        private byte code;

        private AlertDescription(int code) {
            this.code = (byte)code;
        }

        public byte getCode() {
            return this.code;
        }

        public static AlertDescription getDescriptionByCode(int code) {
            switch (code) {
                case 0: {
                    return CLOSE_NOTIFY;
                }
                case 10: {
                    return UNEXPECTED_MESSAGE;
                }
                case 20: {
                    return BAD_RECORD_MAC;
                }
                case 21: {
                    return DECRYPTION_FAILED_RESERVED;
                }
                case 22: {
                    return RECORD_OVERFLOW;
                }
                case 30: {
                    return DECOMPRESSION_FAILURE;
                }
                case 40: {
                    return HANDSHAKE_FAILURE;
                }
                case 41: {
                    return NO_CERTIFICATE_RESERVED;
                }
                case 42: {
                    return BAD_CERTIFICATE;
                }
                case 43: {
                    return UNSUPPORTED_CERTIFICATE;
                }
                case 44: {
                    return CERTIFICATE_REVOKED;
                }
                case 45: {
                    return CERTIFICATE_EXPIRED;
                }
                case 46: {
                    return CERTIFICATE_UNKNOWN;
                }
                case 47: {
                    return ILLEGAL_PARAMETER;
                }
                case 48: {
                    return UNKNOWN_CA;
                }
                case 49: {
                    return ACCESS_DENIED;
                }
                case 50: {
                    return DECODE_ERROR;
                }
                case 51: {
                    return DECRYPT_ERROR;
                }
                case 60: {
                    return EXPORT_RESTRICTION_RESERVED;
                }
                case 70: {
                    return PROTOCOL_VERSION;
                }
                case 71: {
                    return INSUFFICIENT_SECURITY;
                }
                case 80: {
                    return INTERNAL_ERROR;
                }
                case 90: {
                    return USER_CANCELED;
                }
                case 100: {
                    return NO_RENEGOTIATION;
                }
                case 110: {
                    return UNSUPPORTED_EXTENSION;
                }
            }
            return null;
        }

        static String alertDescription(AlertDescription description) {
            switch (description) {
                case CLOSE_NOTIFY: {
                    return "close_notify";
                }
                case UNEXPECTED_MESSAGE: {
                    return "unexpected_message";
                }
                case BAD_RECORD_MAC: {
                    return "bad_record_mac";
                }
                case DECRYPTION_FAILED_RESERVED: {
                    return "decryption_failed";
                }
                case RECORD_OVERFLOW: {
                    return "record_overflow";
                }
                case DECOMPRESSION_FAILURE: {
                    return "decompression_failure";
                }
                case HANDSHAKE_FAILURE: {
                    return "handshake_failure";
                }
                case NO_CERTIFICATE_RESERVED: {
                    return "no_certificate";
                }
                case BAD_CERTIFICATE: {
                    return "bad_certificate";
                }
                case UNSUPPORTED_CERTIFICATE: {
                    return "unsupported_certificate";
                }
                case CERTIFICATE_REVOKED: {
                    return "certificate_revoked";
                }
                case CERTIFICATE_EXPIRED: {
                    return "certificate_expired";
                }
                case CERTIFICATE_UNKNOWN: {
                    return "certificate_unknown";
                }
                case ILLEGAL_PARAMETER: {
                    return "illegal_parameter";
                }
                case UNKNOWN_CA: {
                    return "unknown_ca";
                }
                case ACCESS_DENIED: {
                    return "access_denied";
                }
                case DECODE_ERROR: {
                    return "decode_error";
                }
                case DECRYPT_ERROR: {
                    return "decrypt_error";
                }
                case EXPORT_RESTRICTION_RESERVED: {
                    return "export_restriction";
                }
                case PROTOCOL_VERSION: {
                    return "protocol_version";
                }
                case INSUFFICIENT_SECURITY: {
                    return "insufficient_security";
                }
                case INTERNAL_ERROR: {
                    return "internal_error";
                }
                case USER_CANCELED: {
                    return "user_canceled";
                }
                case NO_RENEGOTIATION: {
                    return "no_negotiation";
                }
                case UNSUPPORTED_EXTENSION: {
                    return "unsupported_extension";
                }
            }
            return "<UNKNOWN ALERT: " + (description.getCode() & 0xFF) + ">";
        }
    }

    public static enum AlertLevel {
        WARNING(1),
        FATAL(2);

        private byte code;

        private AlertLevel(int code) {
            this.code = (byte)code;
        }

        public byte getCode() {
            return this.code;
        }

        public static AlertLevel getLevelByCode(int code) {
            switch (code) {
                case 1: {
                    return WARNING;
                }
                case 2: {
                    return FATAL;
                }
            }
            return null;
        }
    }
}

