/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;

public class DTLSConnectorConfig {
    private int maxFragmentLength = 4096;
    private int maxPayloadSize = this.maxFragmentLength + 25;
    private int retransmissionTimeout = 1000;
    private int maxRetransmit = 4;
    public boolean requireClientAuth = true;
    public boolean sendRawKey = true;
    public PskStore pskStore = null;
    public PrivateKey privateKey = null;
    public Certificate[] certChain = null;
    public CipherSuite preferredCipherSuite = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8;
    private DTLSConnector connector;

    public DTLSConnectorConfig(DTLSConnector connector) {
        this.connector = connector;
    }

    private void checkStarted() {
        if (this.connector.isRunning()) {
            throw new IllegalStateException("can't configure the DTLS connector, it's already started");
        }
    }

    public void setPskStore(PskStore pskStore) {
        this.checkStarted();
        this.pskStore = pskStore;
    }

    public void setPrivateKey(PrivateKey key, Certificate[] certChain, boolean sendRawKey) {
        this.checkStarted();
        this.privateKey = key;
        this.certChain = certChain;
        this.sendRawKey = sendRawKey;
    }

    public void setRequireClientAuth(boolean requireClientAuth) {
        this.checkStarted();
        this.requireClientAuth = requireClientAuth;
    }

    public void setPreferredCipherSuite(CipherSuite suite) {
        this.checkStarted();
        this.preferredCipherSuite = suite;
    }

    public int getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    public void setMaxFragmentLength(int maxFragmentLength) {
        this.maxFragmentLength = maxFragmentLength;
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public void setMaxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    public int getRetransmissionTimeout() {
        return this.retransmissionTimeout;
    }

    public void setRetransmissionTimeout(int retransmissionTimeout) {
        this.retransmissionTimeout = retransmissionTimeout;
    }

    public int getMaxRetransmit() {
        return this.maxRetransmit;
    }

    public void setMaxRetransmit(int maxRetransmit) {
        this.maxRetransmit = maxRetransmit;
    }
}

