/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Endpoint;

public class CoapObserveRelation {
    private Request request;
    private boolean canceled = false;
    private CoapResponse current = null;
    private Endpoint endpoint;

    protected CoapObserveRelation(Request request, Endpoint endpoint) {
        this.request = request;
        this.endpoint = endpoint;
    }

    public void proactiveCancel() {
        Request cancel = Request.newGet();
        cancel.setOptions(this.request.getOptions());
        cancel.setObserveCancel();
        cancel.setToken(this.request.getToken());
        cancel.setDestination(this.request.getDestination());
        cancel.setDestinationPort(this.request.getDestinationPort());
        for (MessageObserver mo : this.request.getMessageObservers()) {
            cancel.addMessageObserver(mo);
        }
        this.endpoint.sendRequest(cancel);
        this.request.cancel();
        this.canceled = true;
    }

    public void reactiveCancel() {
        this.request.cancel();
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public CoapResponse getCurrent() {
        return this.current;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    protected void setCurrent(CoapResponse current) {
        this.current = current;
    }
}

