/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPskStore
implements PskStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncPskStore.class);
    private static final NamedThreadFactory THREAD_FACTORY = new DaemonThreadFactory("AsyncPskStoreTimer#", NamedThreadFactory.SCANDIUM_THREAD_GROUP);
    private final ScheduledExecutorService executorService;
    private final PskStore pskStore;
    private volatile int delayMillis = 1;
    private volatile boolean generateMasterSecret;
    private volatile HandshakeResultHandler resultHandler;

    public AsyncPskStore(PskStore pskStore) {
        this.pskStore = pskStore;
        this.executorService = ExecutorsUtil.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    }

    public AsyncPskStore setSecretMode(boolean enableGenerateMasterSecret) {
        this.generateMasterSecret = enableGenerateMasterSecret;
        return this;
    }

    public AsyncPskStore setDelay(int delayMillis) {
        this.delayMillis = delayMillis;
        if (delayMillis > 0) {
            LOGGER.info("Asynchronous delayed PSK store {}ms.", (Object)delayMillis);
        } else if (delayMillis < 0) {
            LOGGER.info("Synchronous delayed PSK store {}ms.", (Object)(-delayMillis));
        } else {
            LOGGER.info("Synchronous PSK store.");
        }
        return this;
    }

    public int getDelay() {
        return this.delayMillis;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public PskSecretResult requestPskSecretResult(final ConnectionId cid, final ServerNames serverNames, final PskPublicInformation identity, final String hmacAlgorithm, SecretKey otherSecret, byte[] seed, final boolean useExtendedMasterSecret) {
        if (this.delayMillis <= 0) {
            if (this.delayMillis < 0) {
                try {
                    Thread.sleep(-this.delayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.getPskSecretResult(cid, serverNames, identity, hmacAlgorithm, otherSecret, seed, useExtendedMasterSecret);
        }
        final byte[] randomSeed = Arrays.copyOf(seed, seed.length);
        final SecretKey other = SecretUtil.create(otherSecret);
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                AsyncPskStore.this.getSecretAsynchronous(cid, serverNames, identity, hmacAlgorithm, other, randomSeed, useExtendedMasterSecret);
            }
        }, (long)this.delayMillis, TimeUnit.MILLISECONDS);
        return null;
    }

    private void getSecretAsynchronous(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        PskSecretResult result = this.getPskSecretResult(cid, serverNames, identity, hmacAlgorithm, otherSecret, seed, useExtendedMasterSecret);
        this.resultHandler.apply(result);
    }

    private PskSecretResult getPskSecretResult(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        PskSecretResult result = this.pskStore.requestPskSecretResult(cid, serverNames, identity, hmacAlgorithm, otherSecret, seed, useExtendedMasterSecret);
        if (this.generateMasterSecret && result.isPskSecret()) {
            SecretKey masterSecret = result.generateMasterSecret(hmacAlgorithm, otherSecret, seed, useExtendedMasterSecret);
            SecretUtil.destroy(result);
            return new PskSecretResult(cid, result.getPskPublicInformation(), masterSecret, true, true);
        }
        return result;
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
        if (this.resultHandler != null && resultHandler != null && this.resultHandler != resultHandler) {
            throw new IllegalStateException("handshake result handler already set!");
        }
        this.resultHandler = resultHandler;
    }

    @Override
    public boolean hasEcdhePskSupported() {
        return true;
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return this.pskStore.getIdentity(peerAddress, virtualHost);
    }
}

