/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.option.IntegerOption;
import org.eclipse.californium.elements.util.DatagramReader;

public final class BlockOption
extends IntegerOption {
    public static final int BERT_SZX = 7;
    public static final int MAXIMUM_BLOCK_NUM = 1048575;
    private final int szx;
    private final boolean m;
    private final int num;

    public BlockOption(Definition definition, int szx, boolean m, int num) {
        super(definition, BlockOption.encode(szx, m, num));
        this.szx = szx;
        this.m = m;
        this.num = num;
    }

    public BlockOption(Definition definition, int value) {
        super(definition, value);
        this.szx = value & 7;
        this.m = (value & 8) != 0;
        this.num = value >> 4;
    }

    @Override
    public Definition getDefinition() {
        return (Definition)super.getDefinition();
    }

    public boolean isBERT() {
        return this.szx == 7;
    }

    public void assertPayloadSize(int payloadSize) {
        int size;
        if (this.szx < 7 && payloadSize > 0 && payloadSize > (size = this.getSize())) {
            throw new IllegalStateException("Message with " + payloadSize + " bytes payload exceeds the blocksize of " + size + " bytes!");
        }
    }

    public int getSzx() {
        return this.szx;
    }

    public int getSize() {
        return BlockOption.szx2Size(this.szx);
    }

    public boolean isM() {
        return this.m;
    }

    public int getNum() {
        return this.num;
    }

    public int getOffset() {
        return this.num * BlockOption.szx2Size(this.szx);
    }

    @Override
    public String toValueString() {
        return String.format("(szx=%d/%d, m=%b, num=%d)", this.szx, BlockOption.szx2Size(this.szx), this.m, this.num);
    }

    public static int size2Szx(int blockSize) {
        if (blockSize >= 1024) {
            return 6;
        }
        if (blockSize <= 16) {
            return 0;
        }
        int maxOneBit = Integer.highestOneBit(blockSize);
        return Integer.numberOfTrailingZeros(maxOneBit) - 4;
    }

    public static int szx2Size(int szx) {
        if (szx <= 0) {
            return 16;
        }
        if (szx >= 6) {
            return 1024;
        }
        return 1 << szx + 4;
    }

    public static int encode(int szx, boolean m, int num) {
        if (szx < 0 || 7 < szx) {
            throw new IllegalArgumentException("Block option's szx " + szx + " must be between 0 and 7 inclusive");
        }
        if (num < 0 || 1048575 < num) {
            throw new IllegalArgumentException("Block option's num " + num + " must be between 0 and " + 1048575 + " inclusive");
        }
        return szx | (m ? 8 : 0) | num << 4;
    }

    public static class Definition
    extends IntegerOption.Definition {
        public Definition(int number, String name) {
            super(number, name, true, 0, 3);
        }

        @Override
        public BlockOption create(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Option " + this.getName() + " reader must not be null.");
            }
            return new BlockOption(this, Definition.getIntegerValue(reader, length));
        }

        public BlockOption create(int szx, boolean m, int num) {
            return new BlockOption(this, szx, m, num);
        }
    }
}

