/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LimitedRunnable
implements Runnable {
    private final AtomicInteger counter;
    private volatile boolean overflow;

    public LimitedRunnable(AtomicInteger counter) {
        this.counter = counter;
    }

    public void onQueueing() {
        if (this.counter.decrementAndGet() < 0) {
            this.overflow = true;
            throw new RejectedExecutionException("queue overflow!");
        }
    }

    public void onDequeueing() {
        this.counter.incrementAndGet();
    }

    public boolean isOverflown() {
        return this.overflow;
    }

    public void execute(Executor executor) {
        try {
            this.onQueueing();
            executor.execute(this);
        }
        catch (RejectedExecutionException ex) {
            this.onDequeueing();
            throw ex;
        }
    }
}

