/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import com.upokecenter.cbor.CBORObject;
import java.io.ByteArrayOutputStream;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.cose.CoseException;
import org.eclipse.californium.cose.Encrypt0Message;
import org.eclipse.californium.cose.HeaderKeys;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.OSSerializer;
import org.eclipse.californium.oscore.OscoreOptionEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Encryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Encryptor.class);

    protected static byte[] encryptAndEncode(Encrypt0Message enc, OSCoreCtx ctx, Message message, boolean newPartialIV, Integer requestSequenceNr) throws OSException {
        boolean isRequest = message instanceof Request;
        try {
            byte[] key = ctx.getSenderKey();
            byte[] partialIV = null;
            byte[] nonce = null;
            byte[] aad = null;
            if (isRequest) {
                partialIV = OSSerializer.processPartialIV(ctx.getSenderSeq());
                nonce = OSSerializer.nonceGeneration(partialIV, ctx.getSenderId(), ctx.getCommonIV(), ctx.getIVLength());
                aad = OSSerializer.serializeAAD(1, ctx.getAlg(), ctx.getSenderSeq(), ctx.getSenderId(), message.getOptions());
                enc.addAttribute(HeaderKeys.PARTIAL_IV, CBORObject.FromObject(partialIV), 2);
                enc.addAttribute(HeaderKeys.KID, CBORObject.FromObject(ctx.getSenderId()), 2);
            } else {
                if (!newPartialIV) {
                    partialIV = OSSerializer.processPartialIV(requestSequenceNr);
                    nonce = OSSerializer.nonceGeneration(partialIV, ctx.getRecipientId(), ctx.getCommonIV(), ctx.getIVLength());
                } else {
                    partialIV = OSSerializer.processPartialIV(ctx.getSenderSeq());
                    nonce = OSSerializer.nonceGeneration(partialIV, ctx.getSenderId(), ctx.getCommonIV(), ctx.getIVLength());
                }
                aad = OSSerializer.serializeAAD(1, ctx.getAlg(), requestSequenceNr, ctx.getRecipientId(), message.getOptions());
            }
            enc.setExternal(aad);
            enc.addAttribute(HeaderKeys.IV, CBORObject.FromObject(nonce), 4);
            enc.addAttribute(HeaderKeys.Algorithm, ctx.getAlg().AsCBOR(), 4);
            enc.encrypt(key);
            return enc.getEncryptedContent();
        }
        catch (CoseException e) {
            LOGGER.error("COSE/Crypto exception: {}", (Object)e.getMessage());
            throw new OSException(e.getMessage());
        }
    }

    protected static Encrypt0Message prepareCOSEStructure(byte[] confidential) {
        Encrypt0Message enc = new Encrypt0Message(false, true);
        enc.SetContent(confidential);
        return enc;
    }

    protected static byte[] compression(OSCoreCtx ctx, byte[] cipherText, Message message, boolean newPartialIV) {
        boolean request = message instanceof Request;
        ByteArrayOutputStream bRes = new ByteArrayOutputStream();
        OptionSet options = message.getOptions();
        options.removeOscore();
        if (request) {
            message.getOptions().setOscore(Encryptor.encodeOSCoreRequest(ctx));
        } else {
            message.getOptions().setOscore(Encryptor.encodeOSCoreResponse(ctx, newPartialIV));
        }
        if (cipherText != null) {
            message.setPayload(cipherText);
        }
        return bRes.toByteArray();
    }

    public static byte[] encodeOSCoreRequest(OSCoreCtx ctx) {
        OscoreOptionEncoder optionEncoder = new OscoreOptionEncoder();
        if (ctx.getIncludeContextId()) {
            optionEncoder.setIdContext(ctx.getMessageIdContext());
        }
        optionEncoder.setPartialIV(ctx.getSenderSeq());
        optionEncoder.setKid(ctx.getSenderId());
        return optionEncoder.getBytes();
    }

    public static byte[] encodeOSCoreResponse(OSCoreCtx ctx, boolean newPartialIV) {
        OscoreOptionEncoder optionEncoder = new OscoreOptionEncoder();
        if (ctx.getIncludeContextId()) {
            optionEncoder.setIdContext(ctx.getMessageIdContext());
        }
        if (newPartialIV) {
            optionEncoder.setPartialIV(ctx.getSenderSeq());
        }
        return optionEncoder.getBytes();
    }
}

