/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DataStreamReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.PersistentComponentUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedPersistentComponentUtil
extends PersistentComponentUtil {
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE_BITS = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedPersistentComponentUtil.class);
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final byte[] EXPANSION_LABEL = "key expansion".getBytes();
    private String cipherAlgorithm;
    private int keySizeBits;

    public EncryptedPersistentComponentUtil() {
        this(DEFAULT_CIPHER_ALGORITHM, 128);
    }

    public EncryptedPersistentComponentUtil(String cipherAlgorithm, int keySizeBits) {
        this.setCipher(cipherAlgorithm, keySizeBits);
    }

    public void setCipher(String cipherAlgorithm, int keySizeBits) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.keySizeBits = keySizeBits;
    }

    private Cipher init(int mode, SecretKey password, byte[] seed) {
        try {
            Mac hmac = Mac.getInstance(HMAC_ALGORITHM);
            hmac.init(password);
            int ivSize = 16;
            int keySizeBytes = (this.keySizeBits + 8 - 1) / 8;
            byte[] data = EncryptedPersistentComponentUtil.doExpansion(hmac, EXPANSION_LABEL, seed, keySizeBytes + ivSize);
            SecretKeySpec key = new SecretKeySpec(data, 0, keySizeBytes, "AES");
            IvParameterSpec parameterSpec = new IvParameterSpec(data, keySizeBytes, ivSize);
            Bytes.clear(data);
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            cipher.init(mode, (Key)key, parameterSpec);
            return cipher;
        }
        catch (GeneralSecurityException ex) {
            LOGGER.warn("encryption error:", ex);
            return null;
        }
    }

    public InputStream prepare(InputStream in, SecretKey password) {
        DataStreamReader reader = new DataStreamReader(in);
        byte[] seed = reader.readVarBytes(8);
        if (seed != null && seed.length > 0) {
            if (password == null) {
                LOGGER.warn("missing password!");
                return new ByteArrayInputStream(Bytes.EMPTY);
            }
            Cipher cipher = this.init(2, password, seed);
            if (cipher == null) {
                LOGGER.warn("crypto error!");
                return new ByteArrayInputStream(Bytes.EMPTY);
            }
            if (!(in = new CipherInputStream(in, cipher)).markSupported()) {
                in = new BufferedInputStream(in);
            }
        }
        return in;
    }

    public int loadComponents(InputStream in, SecretKey password) {
        return super.loadComponents(this.prepare(in, password));
    }

    public OutputStream prepare(OutputStream out, SecretKey password) throws IOException {
        DatagramWriter writer = new DatagramWriter();
        if (password != null) {
            byte[] seed = new byte[16];
            new SecureRandom().nextBytes(seed);
            Cipher cipher = this.init(1, password, seed);
            if (cipher != null) {
                writer.writeVarBytes(seed, 8);
                writer.writeTo(out);
                out = new CipherOutputStream(out, cipher);
            } else {
                LOGGER.warn("crypto error!");
                password = null;
            }
        }
        if (password == null) {
            writer.writeVarBytes(Bytes.EMPTY, 8);
            writer.writeTo(out);
        }
        return out;
    }

    public void saveComponents(OutputStream out, SecretKey password, long staleThresholdInSeconds) throws IOException {
        OutputStream serversOut = this.prepare(out, password);
        this.saveComponents(serversOut, staleThresholdInSeconds);
        if (serversOut != out) {
            serversOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndRegisterShutdown(String file, char[] password64, final long staleThresholdInSeconds, final Runnable hook) {
        SecretKeySpec tempKey = null;
        if (password64 != null) {
            byte[] secret = StringUtil.base64ToByteArray(password64);
            tempKey = new SecretKeySpec(secret, "PW");
            Bytes.clear(secret);
        }
        final SecretKeySpec key = tempKey;
        final File store = new File(file);
        if (store.exists()) {
            try {
                try (FileInputStream in = new FileInputStream(store);){
                    this.loadComponents(in, key);
                }
                LOGGER.info("Server state read.");
                store.delete();
            }
            catch (IOException ex) {
                LOGGER.warn("Reading server state failed!", ex);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Reading server state failed!", ex);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread("SHUTDOWN"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Shutdown ...");
                if (hook != null) {
                    hook.run();
                }
                store.delete();
                try (FileOutputStream out = new FileOutputStream(store);){
                    EncryptedPersistentComponentUtil.this.saveComponents(out, key, staleThresholdInSeconds);
                }
                catch (IOException ex) {
                    LOGGER.warn("Saving server state failed!", ex);
                    store.delete();
                }
                LOGGER.info("Shutdown.");
            }
        });
    }

    private static final byte[] doExpansion(Mac hmac, byte[] label, byte[] seed, int length) {
        int offset = 0;
        int macLength = hmac.getMacLength();
        byte[] aAndSeed = new byte[macLength + label.length + seed.length];
        byte[] expansion = new byte[length];
        try {
            System.arraycopy(label, 0, aAndSeed, macLength, label.length);
            System.arraycopy(seed, 0, aAndSeed, macLength + label.length, seed.length);
            hmac.update(label);
            hmac.update(seed);
            while (true) {
                hmac.doFinal(aAndSeed, 0);
                hmac.update(aAndSeed);
                int nextOffset = offset + macLength;
                if (nextOffset > length) {
                    hmac.doFinal(aAndSeed, 0);
                    System.arraycopy(aAndSeed, 0, expansion, offset, length - offset);
                } else {
                    hmac.doFinal(expansion, offset);
                    if (nextOffset != length) {
                        offset = nextOffset;
                        hmac.update(aAndSeed, 0, macLength);
                        continue;
                    }
                }
                break;
            }
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        Bytes.clear(aAndSeed);
        return expansion;
    }
}

