/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.CongestionControlLayer;

public abstract class RemoteEndpoint {
    private static final int RTOARRAYSIZE = 3;
    private final InetSocketAddress remoteAddress;
    private final int nstart;
    private final boolean usesBlindEstimator;
    private final Set<Exchange> inFlight;
    private final Queue<Exchange> requestQueue;
    private final Queue<Exchange> responseQueue;
    private final Queue<CongestionControlLayer.PostponedExchange> notifyQueue;
    private boolean processingNotifies;
    private boolean initializedRto;
    private long[] overallRTO;
    private int currentOverallIndex;
    private volatile long currentRTO;
    protected long meanOverallRTO;

    public RemoteEndpoint(InetSocketAddress remoteAddress, int ackTimeout, int nstart, boolean usesBlindEstimator) {
        this.remoteAddress = remoteAddress;
        this.nstart = nstart;
        this.usesBlindEstimator = usesBlindEstimator;
        this.overallRTO = new long[3];
        for (int i = 0; i < 3; ++i) {
            this.overallRTO[i] = ackTimeout;
        }
        this.currentRTO = ackTimeout;
        this.meanOverallRTO = ackTimeout;
        this.currentOverallIndex = 0;
        this.inFlight = new HashSet<Exchange>();
        this.requestQueue = new LinkedList<Exchange>();
        this.responseQueue = new LinkedList<Exchange>();
        this.notifyQueue = new LinkedList<CongestionControlLayer.PostponedExchange>();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Queue<Exchange> getRequestQueue() {
        return this.requestQueue;
    }

    public Queue<Exchange> getResponseQueue() {
        return this.responseQueue;
    }

    public Queue<CongestionControlLayer.PostponedExchange> getNotifyQueue() {
        return this.notifyQueue;
    }

    public void setCurrentRTO(long currentRTO) {
        this.currentRTO = currentRTO;
    }

    public long getCurrentRTO() {
        return this.currentRTO;
    }

    public synchronized boolean startProcessingNotifies() {
        if (this.processingNotifies) {
            return false;
        }
        this.processingNotifies = true;
        return true;
    }

    public synchronized boolean stopProcessingNotifies() {
        if (this.processingNotifies) {
            this.processingNotifies = false;
            return true;
        }
        return false;
    }

    public synchronized boolean initialRto() {
        if (this.initializedRto) {
            return false;
        }
        this.initializedRto = true;
        return true;
    }

    public long getRTO() {
        long rto = this.currentRTO;
        int size = this.getNumberOfOngoingExchanges();
        if (this.usesBlindEstimator && size > 1 && !this.initializedRto) {
            rto *= (long)size;
        }
        return Math.min(rto, 32000L);
    }

    public synchronized void updateRTO(long newRTO) {
        this.overallRTO[this.currentOverallIndex++] = newRTO;
        if (this.currentOverallIndex >= this.overallRTO.length) {
            this.currentOverallIndex = 0;
        }
        long meanRTO = 0L;
        for (int i = 0; i < 3; ++i) {
            meanRTO += this.overallRTO[i];
        }
        this.meanOverallRTO = meanRTO / 3L;
        this.setCurrentRTO(newRTO);
    }

    public synchronized boolean registerExchange(Exchange exchange) {
        if (this.inFlight.contains(exchange)) {
            return true;
        }
        if (this.inFlight.size() < this.nstart) {
            this.inFlight.add(exchange);
            return true;
        }
        return false;
    }

    public synchronized boolean inFlightExchange(Exchange exchange) {
        return this.inFlight.contains(exchange);
    }

    public synchronized boolean removeExchange(Exchange exchange) {
        return this.inFlight.remove(exchange);
    }

    public synchronized int getNumberOfOngoingExchanges() {
        return this.inFlight.size();
    }

    public void checkAging() {
    }

    public abstract void processRttMeasurement(RtoType var1, long var2);

    public static enum RtoType {
        STRONG,
        WEAK,
        NONE;

    }
}

