/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.core.CoapHandler;
import org.eclipse.californium.core.CoapObserveRelation;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.exception.ConnectorException;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapClient.class);
    private Long timeout;
    private String uri;
    private boolean useProxy;
    private String proxyScheme;
    private final AtomicReference<EndpointContext> destinationContext = new AtomicReference();
    private CoAP.Type type = CoAP.Type.CON;
    private int blockwise = 0;
    private ExecutorService executor;
    private volatile ScheduledThreadPoolExecutor secondaryExecutor;
    private volatile boolean detachExecutor;
    private Endpoint endpoint;

    public CoapClient() {
        this("");
    }

    public CoapClient(String uri) {
        this.uri = uri;
    }

    public CoapClient(URI uri) {
        this(uri.toString());
    }

    public CoapClient(String scheme, String host, int port, String ... path) {
        StringBuilder builder = new StringBuilder().append(scheme).append("://").append(host).append(":").append(port);
        for (String element : path) {
            builder.append("/").append(element);
        }
        this.uri = builder.toString();
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public CoapClient setTimeout(Long timeout) {
        this.timeout = timeout;
        return this;
    }

    public String getURI() {
        return this.uri;
    }

    public CoapClient setURI(String uri) {
        if (!this.useProxy && this.proxyScheme == null && !Objects.equals(this.uri, uri)) {
            boolean resetContext = true;
            if (this.uri != null && uri != null) {
                try {
                    URI destUri = new URI(this.uri);
                    URI newDestUri = new URI(uri);
                    resetContext = destUri.getPort() != newDestUri.getPort() || !Objects.equals(destUri.getHost(), newDestUri.getHost());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (resetContext) {
                this.destinationContext.set(null);
            }
        }
        this.uri = uri;
        return this;
    }

    public EndpointContext getDestinationContext() {
        return this.destinationContext.get();
    }

    public CoapClient setDestinationContext(EndpointContext peerContext) {
        this.destinationContext.set(peerContext);
        return this;
    }

    public boolean useProxy() {
        return this.useProxy;
    }

    public CoapClient enableProxy(boolean enable) {
        this.useProxy = enable;
        return this;
    }

    public String getProxyScheme() {
        return this.proxyScheme;
    }

    public CoapClient setProxyScheme(String proxyScheme) {
        this.proxyScheme = proxyScheme;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoapClient useExecutor() {
        boolean failed = true;
        ExecutorService executor = ExecutorsUtil.newFixedThreadPool(1, new NamedThreadFactory("CoapClient(main)#"));
        ScheduledThreadPoolExecutor secondaryExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("CoapClient(secondary)#"));
        CoapClient coapClient = this;
        synchronized (coapClient) {
            if (this.executor == null && this.secondaryExecutor == null) {
                this.executor = executor;
                this.secondaryExecutor = secondaryExecutor;
                this.detachExecutor = false;
                failed = false;
            }
        }
        if (failed) {
            executor.shutdownNow();
            secondaryExecutor.shutdown();
            throw new IllegalStateException("Executor already set or used!");
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                LOGGER.info("using a SingleThreadExecutor for the CoapClient");
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoapClient setExecutors(ExecutorService executor, ScheduledThreadPoolExecutor secondaryExecutor, boolean detach) {
        if (executor == null || secondaryExecutor == null) {
            throw new NullPointerException("Executors must not be null!");
        }
        boolean failed = true;
        CoapClient coapClient = this;
        synchronized (coapClient) {
            if (this.executor == null && this.secondaryExecutor == null) {
                this.executor = executor;
                this.secondaryExecutor = secondaryExecutor;
                this.detachExecutor = detach;
                failed = false;
            }
        }
        if (failed) {
            throw new IllegalStateException("Executor already set or used!");
        }
        return this;
    }

    private synchronized ScheduledThreadPoolExecutor getSecondaryExecutor() {
        if (this.secondaryExecutor == null) {
            this.secondaryExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("CoapClient(secondary)#"));
        }
        this.detachExecutor = false;
        return this.secondaryExecutor;
    }

    public synchronized Endpoint getEndpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoapClient setEndpoint(Endpoint endpoint) {
        CoapClient coapClient = this;
        synchronized (coapClient) {
            this.endpoint = endpoint;
        }
        if (!endpoint.isStarted()) {
            try {
                endpoint.start();
                LOGGER.info("started set client endpoint {}", (Object)endpoint.getAddress());
            }
            catch (IOException e) {
                LOGGER.error("could not set and start client endpoint", e);
            }
        }
        return this;
    }

    public CoapClient useCONs() {
        this.type = CoAP.Type.CON;
        return this;
    }

    public CoapClient useNONs() {
        this.type = CoAP.Type.NON;
        return this;
    }

    public CoapClient useEarlyNegotiation(int size) {
        this.blockwise = size;
        return this;
    }

    public CoapClient useLateNegotiation() {
        this.blockwise = 0;
        return this;
    }

    public boolean ping() {
        return this.ping(this.timeout);
    }

    public boolean ping(long timeout) {
        return this.ping(new Long(timeout));
    }

    private boolean ping(Long timeout) {
        try {
            Request request = Request.newPing();
            request.setToken(Token.EMPTY);
            this.assignClientUriIfEmpty(request);
            Endpoint outEndpoint = this.getEffectiveEndpoint(request);
            if (timeout == null) {
                timeout = outEndpoint.getConfig().get(CoapConfig.EXCHANGE_LIFETIME, TimeUnit.MILLISECONDS);
            }
            request.addMessageObserver(new MessageObserverAdapter(){

                @Override
                public void onContextEstablished(EndpointContext endpointContext) {
                    CoapClient.this.destinationContext.compareAndSet(null, endpointContext);
                }

                @Override
                public void onSendError(Throwable error) {
                    LOGGER.error("send error: {}", (Object)error.getMessage());
                }
            });
            this.send(request, outEndpoint).waitForResponse(timeout);
            return request.isRejected();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    public Set<WebLink> discover() throws ConnectorException, IOException {
        return this.discover(null);
    }

    public Set<WebLink> discover(String query) throws ConnectorException, IOException {
        CoapResponse links;
        Request discover = this.newGet();
        this.assignClientUriIfEmpty(discover);
        discover.getOptions().clearUriPath().clearUriQuery().setUriPath("/.well-known/core");
        if (query != null) {
            discover.getOptions().setUriQuery(query);
        }
        if ((links = this.synchronous(discover)) == null) {
            return null;
        }
        this.setDestinationContextFromResponse(links.advanced());
        if (links.getOptions().getContentFormat() != 40) {
            return Collections.emptySet();
        }
        return LinkFormat.parse(links.getResponseText());
    }

    public CoapResponse get() throws ConnectorException, IOException {
        Request request = this.newGet();
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse get(int accept) throws ConnectorException, IOException {
        Request request = this.newGet();
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public void get(CoapHandler handler) {
        Request request = this.newGet();
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void get(CoapHandler handler, int accept) {
        Request request = this.newGet();
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public CoapResponse post(String payload, int format) throws ConnectorException, IOException {
        Request request = this.newPost();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse post(byte[] payload, int format) throws ConnectorException, IOException {
        Request request = this.newPost();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse post(String payload, int format, int accept) throws ConnectorException, IOException {
        Request request = this.newPost();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse post(byte[] payload, int format, int accept) throws ConnectorException, IOException {
        Request request = this.newPost();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public void post(CoapHandler handler, String payload, int format) {
        Request request = this.newPost();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void post(CoapHandler handler, byte[] payload, int format) {
        Request request = this.newPost();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void post(CoapHandler handler, String payload, int format, int accept) {
        Request request = this.newPost();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void post(CoapHandler handler, byte[] payload, int format, int accept) {
        Request request = this.newPost();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public CoapResponse patch(String payload, int format) throws ConnectorException, IOException {
        Request request = this.newPatch();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse patch(byte[] payload, int format) throws ConnectorException, IOException {
        Request request = this.newPatch();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse patch(String payload, int format, int accept) throws ConnectorException, IOException {
        Request request = this.newPatch();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse patch(byte[] payload, int format, int accept) throws ConnectorException, IOException {
        Request request = this.newPatch();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public void patch(CoapHandler handler, String payload, int format) {
        Request request = this.newPatch();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void patch(CoapHandler handler, byte[] payload, int format) {
        Request request = this.newPatch();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void patch(CoapHandler handler, String payload, int format, int accept) {
        Request request = this.newPatch();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void patch(CoapHandler handler, byte[] payload, int format, int accept) {
        Request request = this.newPatch();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setAccept(accept);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public CoapResponse put(String payload, int format) throws ConnectorException, IOException {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse put(byte[] payload, int format) throws ConnectorException, IOException {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse putIfMatch(String payload, int format, byte[] ... etags) throws ConnectorException, IOException {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        CoapClient.ifMatch(request, etags);
        return this.synchronous(request);
    }

    public CoapResponse putIfMatch(byte[] payload, int format, byte[] ... etags) throws ConnectorException, IOException {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        CoapClient.ifMatch(request, etags);
        return this.synchronous(request);
    }

    public CoapResponse putIfNoneMatch(String payload, int format) throws ConnectorException, IOException {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setIfNoneMatch(true);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public CoapResponse putIfNoneMatch(byte[] payload, int format) throws ConnectorException, IOException {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setIfNoneMatch(true);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public void put(CoapHandler handler, String payload, int format) {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void put(CoapHandler handler, byte[] payload, int format) {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void putIfMatch(CoapHandler handler, String payload, int format, byte[] ... etags) {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        CoapClient.ifMatch(request, etags);
        this.asynchronous(request, handler);
    }

    public void putIfMatch(CoapHandler handler, byte[] payload, int format, byte[] ... etags) {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        this.assignClientUriIfEmpty(request);
        CoapClient.ifMatch(request, etags);
        this.asynchronous(request, handler);
    }

    public void putIfNoneMatch(CoapHandler handler, String payload, int format) {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setIfNoneMatch(true);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public void putIfNoneMatch(CoapHandler handler, byte[] payload, int format) {
        Request request = this.newPut();
        request.setPayload(payload);
        request.getOptions().setContentFormat(format);
        request.getOptions().setIfNoneMatch(true);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public CoapResponse delete() throws ConnectorException, IOException {
        Request request = this.newDelete();
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public void delete(CoapHandler handler) {
        Request request = this.newDelete();
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public CoapResponse validate(byte[] ... etags) throws ConnectorException, IOException {
        Request request = this.newGet();
        CoapClient.etags(request, etags);
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public void validate(CoapHandler handler, byte[] ... etags) {
        Request request = this.newGet();
        CoapClient.etags(request, etags);
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public CoapResponse advanced(Request request) throws ConnectorException, IOException {
        this.assignClientUriIfEmpty(request);
        return this.synchronous(request);
    }

    public void advanced(CoapHandler handler, Request request) {
        this.assignClientUriIfEmpty(request);
        this.asynchronous(request, handler);
    }

    public CoapObserveRelation observeAndWait(CoapHandler handler) throws ConnectorException, IOException {
        Request request = this.newGet();
        request.setObserve();
        return this.observeAndWait(request, handler);
    }

    public CoapObserveRelation observeAndWait(CoapHandler handler, int accept) throws ConnectorException, IOException {
        Request request = this.newGet();
        request.setObserve();
        request.getOptions().setAccept(accept);
        return this.observeAndWait(request, handler);
    }

    public CoapObserveRelation observe(CoapHandler handler) {
        Request request = this.newGet();
        request.setObserve();
        return this.observe(request, handler);
    }

    public CoapObserveRelation observe(CoapHandler handler, int accept) {
        Request request = this.newGet();
        request.setObserve();
        return this.observe(CoapClient.accept(request, accept), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        boolean shutdown;
        ScheduledThreadPoolExecutor secondaryExecutor;
        ExecutorService executor;
        CoapClient coapClient = this;
        synchronized (coapClient) {
            executor = this.executor;
            secondaryExecutor = this.secondaryExecutor;
            shutdown = !this.detachExecutor;
            this.executor = null;
            this.secondaryExecutor = null;
        }
        if (shutdown) {
            if (executor != null) {
                executor.shutdownNow();
            }
            if (secondaryExecutor != null) {
                secondaryExecutor.shutdownNow();
            }
        }
    }

    private void asynchronous(Request request, CoapHandler handler) {
        request.addMessageObserver(new MessageObserverImpl(handler, request.isMulticast()));
        this.send(request);
    }

    private CoapResponse synchronous(Request request) throws ConnectorException, IOException {
        return this.synchronous(request, this.getEffectiveEndpoint(request));
    }

    private CoapResponse synchronous(Request request, Endpoint outEndpoint) throws ConnectorException, IOException {
        try {
            Response response;
            Long timeout = this.getTimeout();
            if (timeout == null) {
                timeout = outEndpoint.getConfig().get(CoapConfig.EXCHANGE_LIFETIME, TimeUnit.MILLISECONDS);
            }
            if ((response = this.send(request, outEndpoint).waitForResponse(timeout)) == null) {
                request.cancel();
                Throwable sendError = request.getSendError();
                if (sendError != null) {
                    if (sendError instanceof ConnectorException) {
                        throw (ConnectorException)sendError;
                    }
                    throw new IOException(sendError);
                }
                return null;
            }
            if (!request.isMulticast()) {
                this.setDestinationContextFromResponse(response);
            }
            return new CoapResponse(response);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Request accept(Request request, int accept) {
        request.getOptions().setAccept(accept);
        return request;
    }

    private static Request etags(Request request, byte[] ... etags) {
        for (byte[] etag : etags) {
            request.getOptions().addETag(etag);
        }
        return request;
    }

    private static Request ifMatch(Request request, byte[] ... etags) {
        for (byte[] etag : etags) {
            request.getOptions().addIfMatch(etag);
        }
        return request;
    }

    public CoapObserveRelation observeAndWait(Request request, CoapHandler handler) throws ConnectorException, IOException {
        if (request.getOptions().hasObserve()) {
            this.assignClientUriIfEmpty(request);
            Endpoint outEndpoint = this.getEffectiveEndpoint(request);
            CoapObserveRelation relation = new CoapObserveRelation(request, outEndpoint, this.getSecondaryExecutor());
            ObserveMessageObserverImpl messageObserver = new ObserveMessageObserverImpl(handler, request.isMulticast(), relation);
            request.addMessageObserver(messageObserver);
            Adapter notificationListener = new Adapter(messageObserver, relation);
            outEndpoint.addNotificationListener(notificationListener);
            relation.setNotificationListener(notificationListener);
            CoapResponse response = this.synchronous(request, outEndpoint);
            if (response == null || !response.advanced().getOptions().hasObserve()) {
                relation.setCanceled(true);
            } else {
                relation.waitForResponse(2000L);
            }
            return relation;
        }
        throw new IllegalArgumentException("please make sure that the request has observe option set.");
    }

    public CoapObserveRelation observe(Request request, CoapHandler handler) {
        if (request.getOptions().hasObserve()) {
            this.assignClientUriIfEmpty(request);
            Endpoint outEndpoint = this.getEffectiveEndpoint(request);
            CoapObserveRelation relation = new CoapObserveRelation(request, outEndpoint, this.getSecondaryExecutor());
            ObserveMessageObserverImpl messageObserver = new ObserveMessageObserverImpl(handler, request.isMulticast(), relation);
            request.addMessageObserver(messageObserver);
            Adapter notificationListener = new Adapter(messageObserver, relation);
            outEndpoint.addNotificationListener(notificationListener);
            relation.setNotificationListener(notificationListener);
            this.send(request, outEndpoint);
            return relation;
        }
        throw new IllegalArgumentException("please make sure that the request has observe option set.");
    }

    protected Request send(Request request) {
        return this.send(request, this.getEffectiveEndpoint(request));
    }

    protected Request send(Request request, Endpoint outEndpoint) {
        if (this.blockwise != 0) {
            request.getOptions().setBlock2(new BlockOption(BlockOption.size2Szx(this.blockwise), false, 0));
        }
        outEndpoint.sendRequest(request);
        return request;
    }

    protected Endpoint getEffectiveEndpoint(Request request) {
        Endpoint myEndpoint = this.getEndpoint();
        if (myEndpoint != null) {
            return myEndpoint;
        }
        return EndpointManager.getEndpointManager().getDefaultEndpoint(request.getScheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Runnable job) {
        block7: {
            ExecutorService executor;
            CoapClient coapClient = this;
            synchronized (coapClient) {
                executor = this.executor;
            }
            if (executor == null) {
                job.run();
            } else {
                try {
                    executor.execute(job);
                }
                catch (RejectedExecutionException ex) {
                    if (executor.isShutdown()) break block7;
                    LOGGER.warn("failed to execute job!");
                }
            }
        }
    }

    private Request newGet() {
        return this.applyRequestType(Request.newGet());
    }

    private Request newPost() {
        return this.applyRequestType(Request.newPost());
    }

    private Request newPatch() {
        return this.applyRequestType(Request.newPatch());
    }

    private Request newPut() {
        return this.applyRequestType(Request.newPut());
    }

    private Request newDelete() {
        return this.applyRequestType(Request.newDelete());
    }

    private Request applyRequestType(Request request) {
        request.setType(this.type);
        return request;
    }

    private Request assignClientUriIfEmpty(Request request) {
        EndpointContext context = this.destinationContext.get();
        if (context != null && request.getDestinationContext() == null) {
            request.setDestinationContext(context);
            if (this.useProxy && this.proxyScheme == null) {
                String scheme = CoAP.getSchemeFromUri(this.uri);
                if (scheme != null && !CoAP.isSupportedScheme(scheme)) {
                    request.setProxyUri(this.uri);
                } else {
                    request.setURI(this.uri);
                }
            } else {
                request.setURI(this.uri);
            }
        } else if (!request.hasURI() && !request.hasProxyURI()) {
            request.setURI(this.uri);
        }
        if (this.proxyScheme != null && !request.hasProxyURI()) {
            request.setProxyScheme(this.proxyScheme);
        }
        return request;
    }

    private void setDestinationContextFromResponse(Response response) {
        this.destinationContext.compareAndSet(null, response.getSourceContext());
    }

    public static class Builder {
        String scheme;
        String host;
        String port;
        String[] path;
        String[] query;

        public Builder(String host, int port) {
            this.host = host;
            this.port = Integer.toString(port);
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(String port) {
            this.port = port;
            return this;
        }

        public Builder port(int port) {
            this.port = Integer.toString(port);
            return this;
        }

        public Builder path(String ... path) {
            this.path = path;
            return this;
        }

        public Builder query(String ... query) {
            this.query = query;
            return this;
        }

        public CoapClient create() {
            StringBuilder builder = new StringBuilder();
            if (this.scheme != null) {
                builder.append(this.scheme).append("://");
            }
            builder.append(this.host).append(":").append(this.port);
            for (String element : this.path) {
                builder.append("/").append(element);
            }
            if (this.query.length > 0) {
                builder.append("?");
            }
            for (int i = 0; i < this.query.length; ++i) {
                builder.append(this.query[i]);
                if (i >= this.query.length - 1) continue;
                builder.append("&");
            }
            return new CoapClient(builder.toString());
        }
    }

    private class ObserveMessageObserverImpl
    extends MessageObserverImpl {
        private final CoapObserveRelation relation;

        public ObserveMessageObserverImpl(CoapHandler handler, boolean multicast, CoapObserveRelation relation) {
            super(handler, multicast);
            this.relation = relation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void deliver(CoapResponse response) {
            CoapObserveRelation coapObserveRelation = this.relation;
            synchronized (coapObserveRelation) {
                if (!this.relation.onResponse(response)) {
                    LOGGER.debug("dropping old notification: {}", (Object)response.advanced());
                    return;
                }
                this.handler.onLoad(response);
            }
        }

        @Override
        protected void failed() {
            this.relation.setCanceled(true);
            super.failed();
        }
    }

    private class MessageObserverImpl
    extends MessageObserverAdapter {
        protected final CoapHandler handler;
        private final boolean multicast;

        private MessageObserverImpl(CoapHandler handler, boolean multicast) {
            this.handler = handler;
            this.multicast = multicast;
        }

        @Override
        public void onResponse(Response response) {
            if (!this.multicast) {
                CoapClient.this.setDestinationContextFromResponse(response);
            }
            this.succeeded(new CoapResponse(response));
        }

        protected void succeeded(final CoapResponse response) {
            CoapClient.this.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageObserverImpl.this.deliver(response);
                    }
                    catch (Throwable t) {
                        LOGGER.warn("exception while handling response", t);
                    }
                }
            });
        }

        protected void deliver(CoapResponse response) {
            this.handler.onLoad(response);
        }

        @Override
        protected void failed() {
            CoapClient.this.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageObserverImpl.this.handler.onError();
                    }
                    catch (Throwable t) {
                        LOGGER.warn("exception while handling failure", t);
                    }
                }
            });
        }
    }

    private class Adapter
    implements NotificationListener {
        private final MessageObserver observer;
        private final CoapObserveRelation relation;

        public Adapter(MessageObserver observer, CoapObserveRelation relation) {
            this.observer = observer;
            this.relation = relation;
        }

        @Override
        public void onNotification(Request request, Response response) {
            if (this.relation.matchRequest(request)) {
                this.observer.onResponse(response);
            }
        }
    }
}

