/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.core.server.ServersSerializationUtil;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.EncryptedPersistentComponentUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class EncryptedServersSerializationUtil
extends ServersSerializationUtil {
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE_BITS = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedServersSerializationUtil.class);
    private EncryptedPersistentComponentUtil encryptedPersistentUtil = new EncryptedPersistentComponentUtil();

    public EncryptedServersSerializationUtil() {
        this(DEFAULT_CIPHER_ALGORITHM, 128, false);
    }

    public EncryptedServersSerializationUtil(String cipherAlgorithm, int keySizeBits) {
        this(cipherAlgorithm, keySizeBits, false);
    }

    public EncryptedServersSerializationUtil(boolean useDeprecatedSerialization) {
        this(DEFAULT_CIPHER_ALGORITHM, 128, useDeprecatedSerialization);
    }

    public EncryptedServersSerializationUtil(String cipherAlgorithm, int keySizeBits, boolean useDeprecatedSerialization) {
        super(useDeprecatedSerialization);
        this.setCipher(cipherAlgorithm, keySizeBits);
        this.persistentUtil = this.encryptedPersistentUtil;
    }

    public void setCipher(String cipherAlgorithm, int keySizeBits) {
        this.encryptedPersistentUtil.setCipher(cipherAlgorithm, keySizeBits);
    }

    public void loadServers(InputStream in, SecretKey password) {
        in = this.encryptedPersistentUtil.prepare(in, password);
        super.loadServers(in);
    }

    public void saveServers(OutputStream out, SecretKey password, long maxQuietPeriodInSeconds) throws IOException {
        OutputStream serversOut = this.encryptedPersistentUtil.prepare(out, password);
        this.saveServers(serversOut, maxQuietPeriodInSeconds);
        if (serversOut != out) {
            serversOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndRegisterShutdown(String file, char[] password64, final long maxQuietPeriodInSeconds) {
        SecretKeySpec tempKey = null;
        if (password64 != null) {
            byte[] secret = StringUtil.base64ToByteArray(password64);
            tempKey = new SecretKeySpec(secret, "PW");
            Bytes.clear(secret);
        }
        final SecretKeySpec key = tempKey;
        final File store = new File(file);
        if (store.exists()) {
            try {
                try (FileInputStream in = new FileInputStream(store);){
                    this.loadServers(in, key);
                }
                LOGGER.info("Server state read.");
                store.delete();
            }
            catch (IOException ex) {
                LOGGER.warn("Reading server state failed!", ex);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Reading server state failed!", ex);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread("SHUTDOWN"){

            @Override
            public void run() {
                LOGGER.info("Shutdown ...");
                store.delete();
                try (FileOutputStream out = new FileOutputStream(store);){
                    EncryptedServersSerializationUtil.this.saveServers(out, key, maxQuietPeriodInSeconds);
                }
                catch (IOException ex) {
                    LOGGER.warn("Saving server state failed!", ex);
                    store.delete();
                }
                LOGGER.info("Shutdown.");
            }
        });
    }
}

