/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.Arrays;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.NoResponseOption;
import org.eclipse.californium.core.coap.option.EmptyOptionDefinition;
import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;
import org.eclipse.californium.core.coap.option.OpaqueOptionDefinition;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.core.coap.option.StringOptionDefinition;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;

public class Option
implements Comparable<Option> {
    private final OptionDefinition definition;
    private byte[] value;

    public Option() {
        this.definition = new OpaqueOptionDefinition(0, "Reserved 0");
        this.setValue(Bytes.EMPTY);
    }

    @Deprecated
    public Option(int number) {
        this.definition = StandardOptionRegistry.getDefaultOptionRegistry().getDefinitionByNumber(number);
        if (this.definition == null) {
            throw new IllegalArgumentException("Unkonwn " + number + " not supported!");
        }
    }

    public Option(OptionDefinition definition) {
        if (definition == null) {
            throw new NullPointerException("Definition must not be null!");
        }
        this.definition = definition;
    }

    public Option(EmptyOptionDefinition definition) {
        this.definition = definition;
        this.setValue(Bytes.EMPTY);
    }

    public Option(OptionDefinition definition, byte[] value) {
        this.definition = definition;
        this.setValue(value);
    }

    public Option(StringOptionDefinition definition, String value) {
        this.definition = definition;
        this.setStringValue(value);
    }

    public Option(IntegerOptionDefinition definition, int value) {
        this.definition = definition;
        this.setIntegerValue(value);
    }

    public Option(IntegerOptionDefinition definition, long value) {
        this.definition = definition;
        this.setLongValue(value);
    }

    @Deprecated
    public Option(int number, String value) {
        this(number);
        this.setStringValue(value);
    }

    @Deprecated
    public Option(int number, int val) {
        this(number);
        this.setIntegerValue(val);
    }

    @Deprecated
    public Option(int number, long val) {
        this(number);
        this.setLongValue(val);
    }

    @Deprecated
    public Option(int number, byte[] opaque) {
        this(number);
        this.setValue(opaque);
    }

    public OptionDefinition getDefinition() {
        return this.definition;
    }

    public int getLength() {
        return this.getValue().length;
    }

    public int getNumber() {
        return this.definition.getNumber();
    }

    public byte[] getValue() {
        if (this.value == null) {
            throw new IllegalStateException(this.definition.getName() + " option value must be set before!");
        }
        return this.value;
    }

    public String getStringValue() {
        return StringOptionDefinition.getStringValue(this.getValue());
    }

    public int getIntegerValue() {
        return IntegerOptionDefinition.getIntegerValue(this.getValue());
    }

    public long getLongValue() {
        return IntegerOptionDefinition.getLongValue(this.getValue());
    }

    public void setValue(byte[] value) {
        if (value == null) {
            throw new NullPointerException(this.definition.getName() + " option value must not be null!");
        }
        this.definition.assertValue(value);
        this.value = value;
    }

    public void setStringValue(String str) {
        this.setValue(StringOptionDefinition.setStringValue(str));
    }

    public void setIntegerValue(int val) {
        this.setValue(IntegerOptionDefinition.setIntegerValue(val));
    }

    public void setLongValue(long val) {
        this.setValue(IntegerOptionDefinition.setLongValue(val));
    }

    public boolean isCritical() {
        return (this.getNumber() & 1) != 0;
    }

    public boolean isUnSafe() {
        return (this.getNumber() & 2) != 0;
    }

    public boolean isNoCacheKey() {
        return (this.getNumber() & 0x1E) == 28;
    }

    @Override
    public int compareTo(Option o) {
        return this.getNumber() - o.getNumber();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option op = (Option)o;
        return this.definition.equals(op.definition) && Arrays.equals(this.value, op.value);
    }

    public int hashCode() {
        return this.definition.hashCode() * 31 + Arrays.hashCode(this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.definition.getName());
        sb.append(": ");
        sb.append(this.toValueString());
        return sb.toString();
    }

    public String toValueString() {
        if (this.value == null) {
            return "not available";
        }
        switch (this.definition.getFormat()) {
            case INTEGER: {
                if (StandardOptionRegistry.BLOCK1.equals(this.definition) || StandardOptionRegistry.BLOCK2.equals(this.definition)) {
                    return "\"" + new BlockOption(this.value) + "\"";
                }
                int iValue = this.getIntegerValue();
                if (StandardOptionRegistry.ACCEPT.equals(this.definition) || StandardOptionRegistry.CONTENT_FORMAT.equals(this.definition)) {
                    return "\"" + MediaTypeRegistry.toString(iValue) + "\"";
                }
                if (StandardOptionRegistry.NO_RESPONSE.equals(this.definition)) {
                    return "\"" + new NoResponseOption(iValue) + "\"";
                }
                return Long.toString(this.getLongValue());
            }
            case STRING: {
                return "\"" + this.getStringValue() + "\"";
            }
            case EMPTY: {
                return "";
            }
        }
        return "0x" + StringUtil.byteArray2Hex(this.value);
    }

    Option setValueUnchecked(byte[] value) {
        this.value = value;
        return this;
    }
}

