/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.unixhealth;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.NotForAndroid;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotForAndroid
public class NetSocketHealthLogger
extends CounterStatisticManager {
    @Deprecated
    protected static final Logger LOGGER = LoggerFactory.getLogger(NetSocketHealthLogger.class);
    private static final File ipv4File = new File("/proc/net/udp");
    private static final File ipv6File = new File("/proc/net/udp6");
    private static final String IPV4_HEADER = "0000000000000000FFFF0000";
    private static final String IPV4_ANY_HEADER = "000000000000000000000000";
    private static final String IPV4_ANY = "00000000:";
    private final Parser parser;
    private final ConcurrentMap<String, SimpleCounterStatistic> externalStatistics = new ConcurrentHashMap<String, SimpleCounterStatistic>();

    public NetSocketHealthLogger(String tag) {
        super(tag);
        this.parser = new UdpParser();
    }

    public boolean add(InetSocketAddress local, SimpleCounterStatistic externalStatistic) {
        UdpAddParser parser = new UdpAddParser(local, externalStatistic);
        this.read(ipv4File, parser);
        if (!parser.added()) {
            this.read(ipv6File, parser);
        }
        return parser.added();
    }

    public void remove(InetSocketAddress local) {
        String localIP = NetSocketHealthLogger.getAddress(local);
        this.removeByKey(localIP);
        if (localIP.length() <= 13) {
            localIP = NetSocketHealthLogger.expandAddressForIpv6(localIP);
            this.removeByKey(localIP);
        }
    }

    @Override
    protected void removeByKey(String key) {
        super.removeByKey(key);
        this.externalStatistics.remove(key);
    }

    @Override
    public boolean isEnabled() {
        return LOGGER.isInfoEnabled() && (ipv4File.canRead() || ipv6File.canRead());
    }

    @Override
    public void dump() {
        if (this.isEnabled()) {
            this.read();
            if (LOGGER.isDebugEnabled()) {
                String eol = StringUtil.lineSeparator();
                String head = "   " + this.tag;
                StringBuilder log = new StringBuilder();
                log.append(this.tag).append("socket drops:").append(eol);
                for (String key : this.getKeys()) {
                    SimpleCounterStatistic statistic = this.getByKey(key);
                    log.append(head).append(statistic).append(eol);
                }
                log.setLength(log.length() - eol.length());
                LOGGER.debug("{}", (Object)log);
            }
            this.transferCounter();
        }
    }

    public boolean read() {
        boolean read = false;
        if (ipv4File.canRead() || ipv6File.canRead()) {
            try {
                if (!this.getKeys().isEmpty()) {
                    read = true;
                    this.read(ipv4File, this.parser);
                    this.read(ipv6File, this.parser);
                }
            }
            catch (Throwable e) {
                LOGGER.error("{}", (Object)this.tag, (Object)e);
            }
        }
        return read;
    }

    private void read(File file, Parser parser) {
        if (file.canRead()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                parser.start();
                while ((line = reader.readLine()) != null && !parser.parse(line.trim())) {
                }
            }
            catch (FileNotFoundException e) {
                LOGGER.warn("{} missing!", (Object)file.getAbsolutePath(), (Object)e);
            }
            catch (IOException e) {
                LOGGER.warn("{} error!", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
    }

    private static int indexOf(String[] fields, String value) {
        for (int index = 0; index < fields.length; ++index) {
            if (!value.equalsIgnoreCase(fields[index])) continue;
            return index;
        }
        return -1;
    }

    private static String expandAddressForIpv6(String local) {
        if (local.length() <= 13) {
            if (local.startsWith(IPV4_ANY)) {
                return IPV4_ANY_HEADER + local;
            }
            return IPV4_HEADER + local;
        }
        return local;
    }

    private static String getAddress(InetSocketAddress local) {
        int port = local.getPort();
        byte[] address = local.getAddress().getAddress();
        StringBuilder builder = new StringBuilder();
        if (address.length == 4) {
            NetSocketHealthLogger.append(builder, address, 0);
        } else {
            NetSocketHealthLogger.append(builder, address, 0);
            NetSocketHealthLogger.append(builder, address, 4);
            NetSocketHealthLogger.append(builder, address, 8);
            NetSocketHealthLogger.append(builder, address, 12);
        }
        builder.append(":").append(String.format("%04X", port));
        return builder.toString();
    }

    private static void append(StringBuilder builder, byte[] address, int index) {
        int end = index + 4;
        while (end > index) {
            builder.append(String.format("%02X", 0xFF & address[--end]));
        }
    }

    private class UdpAddParser
    extends UdpParser {
        private final SimpleCounterStatistic externalStatistic;
        private final InetSocketAddress local;
        private final String localIPv4;
        private final String localIPv6;
        private String key;

        private UdpAddParser(InetSocketAddress local, SimpleCounterStatistic externalStatistic) {
            this.local = local;
            this.externalStatistic = externalStatistic;
            String localIP = NetSocketHealthLogger.getAddress(local);
            if (localIP.length() <= 13) {
                this.localIPv4 = localIP;
                this.localIPv6 = NetSocketHealthLogger.expandAddressForIpv6(localIP);
                LOGGER.trace("search {}/{}", (Object)localIP, (Object)this.localIPv6);
            } else {
                this.localIPv4 = null;
                this.localIPv6 = localIP;
                LOGGER.trace("search {}", (Object)localIP);
            }
        }

        @Override
        protected SimpleCounterStatistic getStatistic(String localAddress) {
            if (localAddress.equalsIgnoreCase(this.localIPv6)) {
                this.key = this.localIPv6;
            }
            if (localAddress.equalsIgnoreCase(this.localIPv4)) {
                this.key = this.localIPv4;
            }
            if (this.key != null) {
                return new SimpleCounterStatistic(StringUtil.toDisplayString(this.local), NetSocketHealthLogger.this.align);
            }
            return null;
        }

        @Override
        protected boolean update(SimpleCounterStatistic statistic, long value) {
            if (this.key != null) {
                statistic.set(value);
                statistic.reset();
                NetSocketHealthLogger.this.addByKey(this.key, statistic);
                LOGGER.trace("added {}", (Object)this.key);
                if (this.externalStatistic != null) {
                    this.externalStatistic.set(value);
                    this.externalStatistic.reset();
                    NetSocketHealthLogger.this.externalStatistics.put(this.key, this.externalStatistic);
                } else {
                    NetSocketHealthLogger.this.externalStatistics.remove(this.key);
                }
            }
            return true;
        }

        private boolean added() {
            return this.key != null;
        }
    }

    private class UdpParser
    implements Parser {
        private static final String LOCAL_ADDRESS = "local_address";
        private static final String DROPS = "drops";
        private boolean start;
        private int localAddressIndex;
        private int dropsIndex;

        private UdpParser() {
        }

        @Override
        public void start() {
            this.start = true;
        }

        @Override
        public boolean parse(String line) {
            SimpleCounterStatistic statistic;
            String[] fields = line.split("\\s+");
            if (this.start) {
                this.start = false;
                this.localAddressIndex = NetSocketHealthLogger.indexOf(fields, LOCAL_ADDRESS);
                this.dropsIndex = NetSocketHealthLogger.indexOf(fields, DROPS) - 2;
                return this.localAddressIndex < 0 || this.dropsIndex < 0;
            }
            if (this.localAddressIndex < fields.length && this.dropsIndex < fields.length && (statistic = this.getStatistic(fields[this.localAddressIndex])) != null) {
                try {
                    long current = Long.parseLong(fields[this.dropsIndex].trim());
                    SimpleCounterStatistic externalStatistic = (SimpleCounterStatistic)NetSocketHealthLogger.this.externalStatistics.get(fields[this.localAddressIndex].toUpperCase());
                    if (externalStatistic != null) {
                        externalStatistic.set(current);
                    }
                    return this.update(statistic, current);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        protected SimpleCounterStatistic getStatistic(String localAddress) {
            return NetSocketHealthLogger.this.getByKey(localAddress.toUpperCase());
        }

        protected boolean update(SimpleCounterStatistic statistic, long value) {
            statistic.set(value);
            return false;
        }
    }

    private static interface Parser {
        public void start();

        public boolean parse(String var1);
    }
}

