/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.interceptors.AnonymizedOriginTracer;
import org.eclipse.californium.core.network.interceptors.HealthStatisticLogger;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.eclipse.californium.elements.PrincipalEndpointContextMatcher;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.IntegerDefinition;
import org.eclipse.californium.elements.config.SystemConfig;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.config.TimeDefinition;
import org.eclipse.californium.elements.tcp.netty.TcpServerConnector;
import org.eclipse.californium.elements.tcp.netty.TlsServerConnector;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.plugtests.PlugtestServer;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.DtlsHealthLogger;
import org.eclipse.californium.scandium.MdcConnectionListener;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.pskstore.AsyncAdvancedPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.MultiPskFileStore;
import org.eclipse.californium.scandium.dtls.resumption.AsyncResumptionVerifier;
import org.eclipse.californium.scandium.dtls.x509.AsyncKeyManagerCertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.AsyncNewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestServer
extends CoapServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapServer.class);
    private static final char[] KEY_STORE_PASSWORD = "endPass".toCharArray();
    private static final String KEY_STORE_LOCATION = "certs/keyStore.jks";
    private static final char[] TRUST_STORE_PASSWORD = "rootPass".toCharArray();
    private static final String TRUST_STORE_LOCATION = "certs/trustStore.jks";
    private static final String SERVER_NAME = "server";
    private static final String PSK_IDENTITY_PREFIX = "cali.";
    private static final SecretKey PSK_SECRET = SecretUtil.create(".fornium".getBytes(), "PSK");
    public static final String ETSI_PSK_IDENTITY = "password";
    public static final SecretKey ETSI_PSK_SECRET = SecretUtil.create("sesame".getBytes(), "PSK");
    public static final String OPENSSL_PSK_IDENTITY = "Client_identity";
    public static final SecretKey OPENSSL_PSK_SECRET = SecretUtil.create("secretPSK".getBytes(), "PSK");
    public static final TimeDefinition DTLS_HANDSHAKE_RESULT_DELAY = new TimeDefinition("DTLS_HANDSHAKE_RESULT_DELAY", "Delay for DTLS handshake results. Only for testing!!!\n0 no delay, < 0 blocking delay, > 0 non-blocking delay.");
    public static final Pattern HONO_IDENTITY_PATTERN = Pattern.compile("^[^@]{8,}@.{8,}$");
    public static final SecretKey HONO_PSK_SECRET = SecretUtil.create("secret".getBytes(), "PSK");
    public static final Pattern IPV6_SCOPE = Pattern.compile("^([0-9a-fA-F:]+)(%\\w+)?$");
    public static final IntegerDefinition EXTERNAL_UDP_PREFERRED_BLOCK_SIZE = new IntegerDefinition("EXTERNAL_UDP_PREFERRED_BLOCK_SIZE", "Preferred blocksize for blockwise transfer with coap/UDP using an external network interface.", 64, 16);
    public static final IntegerDefinition EXTERNAL_UDP_MAX_MESSAGE_SIZE = new IntegerDefinition("EXTERNAL_UDP_MAX_MESSAGE_SIZE", "Maximum payload size with coap/UDP using an external network interface.", 64, 16);
    public static final TimeDefinition UDP_DROPS_READ_INTERVAL = new TimeDefinition("UDP_DROPS_READ_INTERVAL", "Interval to read upd drops from OS (currently only Linux).", 2000L, TimeUnit.MILLISECONDS);
    private final Configuration config;
    private final Map<Select, Configuration> selectConfig;
    private AtomicBoolean loadCredentials = new AtomicBoolean(true);
    protected KeyManager[] serverCredentials = null;
    protected Certificate[] trustedCertificates = null;
    protected SSLContext serverSslContext = null;

    protected AbstractTestServer(Configuration config, Map<Select, Configuration> selectConfig) {
        super(config, new int[0]);
        this.config = config;
        this.selectConfig = selectConfig;
    }

    public Configuration getConfig(Select select) {
        Configuration udpConfig;
        if (this.selectConfig != null && (udpConfig = this.selectConfig.get(select)) != null) {
            return udpConfig;
        }
        return this.config;
    }

    public Configuration getConfig(Protocol protocol, InterfaceType interfaceType) {
        if (this.selectConfig != null) {
            Select select = new Select(protocol, interfaceType);
            Configuration udpConfig = this.selectConfig.get(select);
            if (udpConfig != null) {
                return udpConfig;
            }
            select = new Select(protocol);
            udpConfig = this.selectConfig.get(select);
            if (udpConfig != null) {
                return udpConfig;
            }
            select = new Select(interfaceType);
            udpConfig = this.selectConfig.get(select);
            if (udpConfig != null) {
                return udpConfig;
            }
        }
        return this.config;
    }

    protected void initCredentials() {
        if (this.loadCredentials.compareAndSet(true, false)) {
            try {
                this.serverCredentials = SslContextUtil.loadKeyManager("classpath://certs/keyStore.jks", "server.*", KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
                this.trustedCertificates = SslContextUtil.loadTrustedCertificates("classpath://certs/trustStore.jks", null, TRUST_STORE_PASSWORD);
                return;
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected SSLContext getServerSslContext(boolean trustAll, String protocol) {
        this.initCredentials();
        try {
            if (this.serverCredentials != null) {
                TrustManager[] trustManager = trustAll ? SslContextUtil.createTrustAllManager() : SslContextUtil.createTrustManager(SERVER_NAME, this.trustedCertificates);
                SSLContext sslContext = SSLContext.getInstance(protocol);
                sslContext.init(this.serverCredentials, trustManager, null);
                return sslContext;
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addEndpoints(PlugtestServer.BaseConfig cliConfig) {
        int coapPort = this.config.get(CoapConfig.COAP_PORT);
        int coapsPort = this.config.get(CoapConfig.COAP_SECURE_PORT);
        List<Protocol> protocols = cliConfig.getProtocols();
        if (protocols.contains((Object)Protocol.DTLS) || protocols.contains((Object)Protocol.TLS)) {
            this.initCredentials();
            this.serverSslContext = this.getServerSslContext(cliConfig.trustall, "TLSv1.2");
            if (this.serverSslContext == null && protocols.contains((Object)Protocol.TLS)) {
                throw new IllegalArgumentException("TLS not supported, credentials missing!");
            }
        }
        for (InetAddress addr : NetworkInterfacesUtil.getNetworkInterfaces(cliConfig.getFilter(this.getTag()))) {
            InetSocketAddress bindToAddress;
            InterfaceType interfaceType;
            InterfaceType interfaceType2 = interfaceType = addr.isLoopbackAddress() ? InterfaceType.LOCAL : InterfaceType.EXTERNAL;
            if (protocols.contains((Object)Protocol.UDP) || protocols.contains((Object)Protocol.TCP)) {
                bindToAddress = new InetSocketAddress(addr, coapPort);
                if (protocols.contains((Object)Protocol.UDP)) {
                    Configuration udpConfig = this.getConfig(Protocol.UDP, interfaceType);
                    CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
                    builder.setInetSocketAddress(bindToAddress);
                    builder.setConfiguration(udpConfig);
                    CoapEndpoint endpoint = builder.build();
                    this.addEndpoint(endpoint);
                    this.print(endpoint, interfaceType);
                }
                if (protocols.contains((Object)Protocol.TCP)) {
                    Configuration tcpConfig = this.getConfig(Protocol.TCP, interfaceType);
                    TcpServerConnector connector = new TcpServerConnector(bindToAddress, tcpConfig);
                    CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
                    builder.setConnector(connector);
                    builder.setConfiguration(tcpConfig);
                    CoapEndpoint endpoint = builder.build();
                    this.addEndpoint(endpoint);
                    this.print(endpoint, interfaceType);
                }
            }
            if (!protocols.contains((Object)Protocol.DTLS) && !protocols.contains((Object)Protocol.TLS)) continue;
            bindToAddress = new InetSocketAddress(addr, coapsPort);
            if (protocols.contains((Object)Protocol.DTLS)) {
                boolean certificate;
                Configuration dtlsConfig = this.getConfig(Protocol.DTLS, interfaceType);
                int handshakeResultDelayMillis = dtlsConfig.getTimeAsInt(DTLS_HANDSHAKE_RESULT_DELAY, TimeUnit.MILLISECONDS);
                DtlsConnectorConfig.Builder dtlsConfigBuilder = DtlsConnectorConfig.builder(dtlsConfig);
                dtlsConfigBuilder.setAddress(bindToAddress);
                String tag = "dtls:" + StringUtil.toString(bindToAddress);
                dtlsConfigBuilder.setLoggingTag(tag);
                List list = (List)((Object)dtlsConfig.get(DtlsConfig.DTLS_CIPHER_SUITES));
                boolean psk = list == null || CipherSuite.containsPskBasedCipherSuite(list);
                boolean bl = certificate = list == null || CipherSuite.containsCipherSuiteRequiringCertExchange(list);
                if (psk || cliConfig.pskFile != null) {
                    PlugPskStore pskStore = new PlugPskStore();
                    if (cliConfig.pskFile != null) {
                        pskStore.loadPskCredentials(cliConfig.pskFile);
                    }
                    AsyncAdvancedPskStore asyncPskStore = new AsyncAdvancedPskStore(pskStore);
                    asyncPskStore.setDelay(handshakeResultDelayMillis);
                    dtlsConfigBuilder.setAdvancedPskStore(asyncPskStore);
                }
                if (certificate) {
                    if (cliConfig.clientAuth != null) {
                        dtlsConfigBuilder.set(DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, cliConfig.clientAuth);
                    }
                    X509KeyManager keyManager = SslContextUtil.getX509KeyManager(this.serverCredentials);
                    AsyncKeyManagerCertificateProvider certificateProvider = new AsyncKeyManagerCertificateProvider(keyManager, (List)((Object)dtlsConfig.get(DtlsConfig.DTLS_CERTIFICATE_TYPES)));
                    certificateProvider.setDelay(handshakeResultDelayMillis);
                    dtlsConfigBuilder.setCertificateIdentityProvider(certificateProvider);
                    AsyncNewAdvancedCertificateVerifier.Builder verifierBuilder = AsyncNewAdvancedCertificateVerifier.builder();
                    if (cliConfig.trustall) {
                        verifierBuilder.setTrustAllCertificates();
                    } else {
                        verifierBuilder.setTrustedCertificates(this.trustedCertificates);
                    }
                    verifierBuilder.setTrustAllRPKs();
                    AsyncNewAdvancedCertificateVerifier verifier = verifierBuilder.build();
                    verifier.setDelay(handshakeResultDelayMillis);
                    dtlsConfigBuilder.setAdvancedCertificateVerifier(verifier);
                    AsyncResumptionVerifier resumptionVerifier = new AsyncResumptionVerifier();
                    resumptionVerifier.setDelay(handshakeResultDelayMillis);
                    dtlsConfigBuilder.setResumptionVerifier(resumptionVerifier);
                }
                dtlsConfigBuilder.setConnectionListener(new MdcConnectionListener());
                if (dtlsConfig.get(SystemConfig.HEALTH_STATUS_INTERVAL, TimeUnit.MILLISECONDS) > 0L) {
                    DtlsHealthLogger health = new DtlsHealthLogger(tag);
                    dtlsConfigBuilder.setHealthHandler(health);
                    this.add(health);
                    dtlsConfigBuilder.set(SystemConfig.HEALTH_STATUS_INTERVAL, 0, TimeUnit.MILLISECONDS);
                }
                DTLSConnector connector = new DTLSConnector(dtlsConfigBuilder.build());
                CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
                builder.setConnector(connector);
                if (CoapConfig.MatcherMode.PRINCIPAL == dtlsConfig.get(CoapConfig.RESPONSE_MATCHING)) {
                    builder.setEndpointContextMatcher(new PrincipalEndpointContextMatcher(true));
                }
                builder.setConfiguration(dtlsConfig);
                CoapEndpoint endpoint = builder.build();
                this.addEndpoint(endpoint);
                this.print(endpoint, interfaceType);
            }
            if (!protocols.contains((Object)Protocol.TLS) || this.serverSslContext == null) continue;
            Configuration tlsConfig = this.getConfig(Protocol.TLS, interfaceType);
            if (cliConfig.clientAuth != null) {
                tlsConfig.set(TcpConfig.TLS_CLIENT_AUTHENTICATION_MODE, cliConfig.clientAuth);
            }
            int maxPeers = tlsConfig.get(CoapConfig.MAX_ACTIVE_PEERS);
            int sessionTimeout = tlsConfig.getTimeAsInt(TcpConfig.TLS_SESSION_TIMEOUT, TimeUnit.SECONDS);
            SSLSessionContext serverSessionContext = this.serverSslContext.getServerSessionContext();
            if (serverSessionContext != null) {
                serverSessionContext.setSessionTimeout(sessionTimeout);
                serverSessionContext.setSessionCacheSize(maxPeers);
            }
            TlsServerConnector connector = new TlsServerConnector(this.serverSslContext, bindToAddress, tlsConfig);
            CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
            builder.setConnector(connector);
            builder.setConfiguration(tlsConfig);
            CoapEndpoint endpoint = builder.build();
            this.addEndpoint(endpoint);
            this.print(endpoint, interfaceType);
        }
    }

    protected void print(Endpoint endpoint, InterfaceType interfaceType) {
        LOGGER.info("{}listen on {} ({}) max msg size: {}, block size: {}", new Object[]{this.getTag(), endpoint.getUri(), interfaceType, endpoint.getConfig().get(CoapConfig.MAX_MESSAGE_SIZE), endpoint.getConfig().get(CoapConfig.PREFERRED_BLOCK_SIZE)});
    }

    public void addLogger(boolean messageTracer) {
        for (Endpoint ep : this.getEndpoints()) {
            HealthStatisticLogger healthLogger;
            long healthStatusIntervalMillis;
            URI uri = ep.getUri();
            String scheme = uri.getScheme();
            if (messageTracer) {
                ep.addInterceptor(new MessageTracer());
                ep.addInterceptor(new AnonymizedOriginTracer(uri.getPort() + "-" + scheme));
            }
            if (!ep.getPostProcessInterceptors().isEmpty() || (healthStatusIntervalMillis = ep.getConfig().get(SystemConfig.HEALTH_STATUS_INTERVAL, TimeUnit.MILLISECONDS).longValue()) <= 0L || !(healthLogger = new HealthStatisticLogger(uri.toASCIIString(), CoAP.isUdpScheme(scheme))).isEnabled()) continue;
            ep.addPostProcessInterceptor(healthLogger);
            this.add(healthLogger);
        }
    }

    public static class PlugPskStore
    extends MultiPskFileStore {
        private static final Logger LOGGER = LoggerFactory.getLogger(PlugPskStore.class);
        private final PskPublicInformation identity = new PskPublicInformation("cali.sandbox");

        public PlugPskStore() {
            this.addKey(AbstractTestServer.ETSI_PSK_IDENTITY, ETSI_PSK_SECRET);
            this.addKey(AbstractTestServer.OPENSSL_PSK_IDENTITY, OPENSSL_PSK_SECRET);
        }

        private SecretKey getWildcardKey(String identity) {
            if (identity.startsWith(AbstractTestServer.PSK_IDENTITY_PREFIX)) {
                return PSK_SECRET;
            }
            if (HONO_IDENTITY_PATTERN.matcher(identity).matches()) {
                return HONO_PSK_SECRET;
            }
            return null;
        }

        @Override
        public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
            PskSecretResult result = super.requestPskSecretResult(cid, serverName, identity, hmacAlgorithm, otherSecret, seed, useExtendedMasterSecret);
            if (result.getSecret() == null) {
                SecretKey key = this.getWildcardKey(identity.getPublicInfoAsString());
                LOGGER.trace("{}: {}", (Object)identity, (Object)(key != null ? "found wildcard key" : "no wildcard key"));
                if (key != null) {
                    result = new PskSecretResult(cid, identity, SecretUtil.create(key));
                }
            }
            return result;
        }

        @Override
        public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
            return this.identity;
        }
    }

    public static class Select {
        public final Protocol protocol;
        public final InterfaceType interfaceType;

        public Select(Protocol protocol) {
            this.protocol = protocol;
            this.interfaceType = null;
        }

        public Select(InterfaceType interfaceType) {
            this.protocol = null;
            this.interfaceType = interfaceType;
        }

        public Select(Protocol protocol, InterfaceType interfaceType) {
            this.protocol = protocol;
            this.interfaceType = interfaceType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.interfaceType == null ? 0 : this.interfaceType.hashCode());
            result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Select other = (Select)obj;
            if (this.interfaceType != other.interfaceType) {
                return false;
            }
            return this.protocol == other.protocol;
        }
    }

    public static enum InterfaceType {
        LOCAL,
        EXTERNAL,
        IPV4,
        IPV6;

    }

    public static enum Protocol {
        UDP,
        DTLS,
        TCP,
        TLS;

    }
}

